/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.time;

public class StopWatch {
    private static final long NANO_2_MILLIS = 1000000L;
    private static final int STATE_UNSTARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_SUSPENDED = 3;
    private int state = 0;
    private long startTime;
    private long startTimeMillis;
    private long stopTime;

    public static StopWatch startNew() {
        StopWatch sw = new StopWatch();
        sw.start();
        return sw;
    }

    public StopWatch start() {
        if (this.state == 2) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted. ");
        }
        if (this.state != 0) {
            throw new IllegalStateException("Stopwatch already started. ");
        }
        this.startTime = System.nanoTime();
        this.startTimeMillis = System.currentTimeMillis();
        this.state = 1;
        return this;
    }

    public StopWatch stop() {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        if (this.state == 1) {
            this.stopTime = System.nanoTime();
        }
        this.state = 2;
        return this;
    }

    public StopWatch reset() {
        this.state = 0;
        return this;
    }

    public StopWatch restart() {
        this.reset();
        this.start();
        return this;
    }

    public StopWatch suspend() {
        if (this.state != 1) {
            throw new IllegalStateException("Stopwatch must be running to suspend. ");
        }
        this.stopTime = System.nanoTime();
        this.state = 3;
        return this;
    }

    public StopWatch resume() {
        if (this.state != 3) {
            throw new IllegalStateException("Stopwatch must be suspended to resume. ");
        }
        this.startTime += System.nanoTime() - this.stopTime;
        this.state = 1;
        return this;
    }

    public long getElapsedMilliseconds() {
        return this.getElapsedNanoseconds() / 1000000L;
    }

    public long getElapsedNanoseconds() {
        if (this.state == 2 || this.state == 3) {
            return this.stopTime - this.startTime;
        }
        if (this.state == 0) {
            return 0L;
        }
        if (this.state == 1) {
            return System.nanoTime() - this.startTime;
        }
        throw new IllegalStateException("Illegal running state has occured. ");
    }

    public long getStartTime() {
        if (this.state == 0) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.startTimeMillis;
    }

    public String toString() {
        return this.getElapsedMilliseconds() + "ms";
    }
}

