/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.tools;

import javax.servlet.ServletContext;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.resource.FileResource;
import leap.lang.resource.Resources;
import leap.lang.servlet.ServletResource;
import leap.lang.servlet.Servlets;

public class DEV {
    private static final Log log = LogFactory.get(DEV.class);
    private static final ThreadLocal<Class<?>> testClass = new ThreadLocal();

    public static void setCurrentTestClass(Class<?> cls) {
        testClass.set(cls);
    }

    public static Class<?> getCurrentTestClass() {
        return testClass.get();
    }

    public static boolean isRunningTest() {
        return null != DEV.getCurrentTestClass();
    }

    public static boolean isDevProject(Object externalContext) {
        return DEV.getProjectHome(externalContext) != null;
    }

    public static FileResource getProjectHome(Object externalContext) {
        if (DEV.isServletContext(externalContext)) {
            return DEV.getWebAppMavenProjectHome(externalContext);
        }
        return DEV.getStandaloneMavenProjectHome();
    }

    private static boolean isServletContext(Object externalContext) {
        return externalContext instanceof ServletContext;
    }

    private static FileResource getWebAppMavenProjectHome(Object externalContext) {
        ServletContext sc = (ServletContext)externalContext;
        try {
            ServletResource r = Servlets.getResource(sc, "/WEB-INF");
            if (r.exists() && r.isFile()) {
                FileResource dir = Resources.createFileResource(r.getFile());
                if (dir.createRelative("../../../../target/classes").exists()) {
                    return dir.createRelative("../../../../");
                }
                if (dir.createRelative("../../../../../target/classes").exists()) {
                    return dir.createRelative("../../../../../");
                }
            }
            return null;
        }
        catch (Exception e) {
            log.warn("Error detecting maven project home in webapp," + e.getMessage(), e);
            return null;
        }
    }

    protected static FileResource getStandaloneMavenProjectHome() {
        FileResource userDir = Resources.getUserDir();
        if (userDir.createRelative("target/classes").exists()) {
            return userDir;
        }
        return null;
    }
}

