/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.tostring;

import leap.lang.tostring.DefaultToStringStyler;
import leap.lang.tostring.StylerUtils;
import leap.lang.tostring.ToStringStyler;
import leap.lang.tostring.ValueStyler;

public class ToStringBuilder {
    private static final ToStringStyler DEFAULT_TO_STRING_STYLER = new DefaultToStringStyler(StylerUtils.DEFAULT_VALUE_STYLER);
    private StringBuilder buffer = new StringBuilder(512);
    private ToStringStyler styler;
    private Object object;
    private boolean styledFirstField;

    public ToStringBuilder() {
        this(null, (ToStringStyler)null);
    }

    public ToStringBuilder(Object obj) {
        this(obj, (ToStringStyler)null);
    }

    ToStringBuilder(Object obj, ValueStyler styler) {
        this(obj, new DefaultToStringStyler(styler != null ? styler : StylerUtils.DEFAULT_VALUE_STYLER));
    }

    ToStringBuilder(Object obj, ToStringStyler styler) {
        this.object = obj;
        ToStringStyler toStringStyler = this.styler = styler != null ? styler : DEFAULT_TO_STRING_STYLER;
        if (null != obj) {
            this.styler.styleStart(this.buffer, this.object);
        } else {
            this.styler.styleStart(this.buffer);
        }
    }

    public ToStringBuilder append(String fieldName, byte value) {
        return this.append(fieldName, new Byte(value));
    }

    public ToStringBuilder append(String fieldName, short value) {
        return this.append(fieldName, new Short(value));
    }

    public ToStringBuilder append(String fieldName, int value) {
        return this.append(fieldName, new Integer(value));
    }

    public ToStringBuilder append(String fieldName, long value) {
        return this.append(fieldName, new Long(value));
    }

    public ToStringBuilder append(String fieldName, float value) {
        return this.append(fieldName, new Float(value));
    }

    public ToStringBuilder append(String fieldName, double value) {
        return this.append(fieldName, new Double(value));
    }

    public ToStringBuilder append(String fieldName, boolean value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, Object value) {
        if (this.styledFirstField) {
            this.styler.styleFieldSeparator(this.buffer);
            this.styler.styleField(this.buffer, fieldName, value, false);
        } else {
            this.styler.styleField(this.buffer, fieldName, value, true);
            this.styledFirstField = true;
        }
        return this;
    }

    public ToStringBuilder append(Object value) {
        this.styler.styleValue(this.buffer, value);
        return this;
    }

    public String toString() {
        if (null != this.object) {
            this.styler.styleEnd(this.buffer, this.object);
        } else {
            this.styler.styleEnd(this.buffer);
        }
        return this.buffer.toString();
    }
}

