/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.util;

import java.security.SecureRandom;
import java.util.Random;
import leap.lang.Buildable;

public class ShortID {
    private static final ShortID INSTANCE = new Builder().build();
    public static final String DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
    public static final String DOLLARAT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$@";
    private static final long DEFAULT_REDUCE_TIME = 1403265799803L;
    private static final int DEFAULT_VERSION = 6;
    private final Random random;
    private final long reduceTime;
    private final int version;
    private final int clusterWorkerId;
    private volatile int counter;
    private volatile long previousSeconds;
    private final char[] shuffled;

    public static String randomID() {
        return INSTANCE.generate();
    }

    private ShortID(Random random, String alphabet, long reduceTime, int version, int clusterWorkerId) {
        this.random = random;
        this.shuffled = this.shuffle(alphabet);
        this.reduceTime = reduceTime;
        this.version = version;
        this.clusterWorkerId = clusterWorkerId;
    }

    public String generate() {
        String str = "";
        long seconds = (long)Math.floor((double)(System.currentTimeMillis() - this.reduceTime) * 0.001);
        if (seconds == this.previousSeconds) {
            ++this.counter;
        } else {
            this.counter = 0;
            this.previousSeconds = seconds;
        }
        str = str + this.encode(this.version);
        str = str + this.encode(this.clusterWorkerId);
        if (this.counter > 0) {
            str = str + this.encode(this.counter);
        }
        str = str + this.encode((int)seconds);
        return str;
    }

    private String encode(int number) {
        int loopCounter = 0;
        boolean done = false;
        String str = "";
        while (!done) {
            int index = number >> 4 * loopCounter & 0xF | this.randomByte();
            str = str + this.shuffled[index];
            done = (double)number < Math.pow(16.0, loopCounter + 1);
            ++loopCounter;
        }
        return str;
    }

    private int randomByte() {
        byte[] bytes = new byte[1];
        this.random.nextBytes(bytes);
        return bytes[0] & 0x30;
    }

    private char[] shuffle(String alphabet) {
        StringBuilder source = new StringBuilder(alphabet);
        StringBuilder target = new StringBuilder(source.length());
        while (source.length() > 0) {
            double r = this.random.nextDouble();
            int charIndex = (int)Math.floor(r * (double)source.length());
            target.append(source.charAt(charIndex));
            source.deleteCharAt(charIndex);
        }
        return target.toString().toCharArray();
    }

    public static final class Builder
    implements Buildable<ShortID> {
        private Random random;
        private String alphabet;
        private Long reduceTime;
        private Integer version;
        private Integer clusterWorkerId;

        public Random getRandom() {
            return this.random;
        }

        public void setRandom(Random random) {
            this.random = random;
        }

        public String getAlphabet() {
            return this.alphabet;
        }

        public void setAlphabet(String alphabet) {
            this.alphabet = alphabet;
        }

        public Long getReduceTime() {
            return this.reduceTime;
        }

        public void setReduceTime(Long reduceTime) {
            this.reduceTime = reduceTime;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public Integer getClusterWorkerId() {
            return this.clusterWorkerId;
        }

        public void setClusterWorkerId(Integer clusterWorkerId) {
            this.clusterWorkerId = clusterWorkerId;
        }

        @Override
        public ShortID build() {
            if (null == this.random) {
                this.random = new SecureRandom();
            }
            if (null == this.alphabet) {
                this.alphabet = ShortID.DEFAULT_ALPHABET;
            } else if (this.alphabet.length() != ShortID.DEFAULT_ALPHABET.length()) {
                throw new IllegalStateException("The alphabet's length must be " + ShortID.DEFAULT_ALPHABET.length());
            }
            if (null == this.reduceTime) {
                this.reduceTime = 1403265799803L;
            }
            if (null == this.version) {
                this.version = 6;
            } else if (this.version < 1 || this.version > 16) {
                throw new IllegalStateException("The version must between 1 and 16");
            }
            if (null == this.clusterWorkerId) {
                this.clusterWorkerId = 0;
            }
            return new ShortID(this.random, this.alphabet, this.reduceTime, this.version, this.clusterWorkerId);
        }
    }
}

