/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.value;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTimeOffset
implements Serializable,
Comparable<DateTimeOffset> {
    private static final long serialVersionUID = 541973748553014280L;
    private final long utcMillis;
    private final int nanos;
    private final int minutesOffset;
    private static final int NANOS_MIN = 0;
    private static final int NANOS_MAX = 999999999;
    private static final int MINUTES_OFFSET_MIN = -840;
    private static final int MINUTES_OFFSET_MAX = 840;
    private static final int HUNDRED_NANOS_PER_SECOND = 10000000;
    private String formattedValue = null;

    private DateTimeOffset(Timestamp paramTimestamp, int paramInt) {
        if (paramInt < -840 || paramInt > 840) {
            throw new IllegalArgumentException();
        }
        this.minutesOffset = paramInt;
        int i = paramTimestamp.getNanos();
        if (i < 0 || i > 999999999) {
            throw new IllegalArgumentException();
        }
        int j = (i + 50) / 100;
        this.nanos = 100 * (j % 10000000);
        this.utcMillis = paramTimestamp.getTime() - (long)(paramTimestamp.getNanos() / 1000000) + (long)(1000 * (j / 10000000));
        assert (this.minutesOffset >= -840 && this.minutesOffset <= 840) : "minutesOffset: " + this.minutesOffset;
        assert (this.nanos >= 0 && this.nanos <= 999999999) : "nanos: " + this.nanos;
        assert (0 == this.nanos % 100) : "nanos: " + this.nanos;
        assert (0L == this.utcMillis % 1000L) : "utcMillis: " + this.utcMillis;
    }

    public static DateTimeOffset valueOf(Timestamp paramTimestamp, int paramInt) {
        return new DateTimeOffset(paramTimestamp, paramInt);
    }

    public static DateTimeOffset valueOf(Timestamp paramTimestamp, Calendar paramCalendar) {
        paramCalendar.setTimeInMillis(paramTimestamp.getTime());
        return new DateTimeOffset(paramTimestamp, (paramCalendar.get(15) + paramCalendar.get(16)) / 60000);
    }

    public String toString() {
        String str1 = this.formattedValue;
        if (null == str1) {
            String str2 = this.minutesOffset < 0 ? String.format(Locale.US, "-%1$02d:%2$02d", -this.minutesOffset / 60, -this.minutesOffset % 60) : String.format(Locale.US, "+%1$02d:%2$02d", this.minutesOffset / 60, this.minutesOffset % 60);
            Calendar localCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + str2), Locale.US);
            localCalendar.setTimeInMillis(this.utcMillis);
            assert (this.nanos >= 0 && this.nanos <= 999999999);
            str1 = 0 == this.nanos ? String.format(Locale.US, "%1$tF %1$tT %2$s", localCalendar, str2) : String.format(Locale.US, "%1$tF %1$tT.%2$s %3$s", localCalendar, BigDecimal.valueOf(this.nanos, 9).stripTrailingZeros().toPlainString().substring(2), str2);
            this.formattedValue = str1;
        }
        return str1;
    }

    public boolean equals(Object paramObject) {
        if (this == paramObject) {
            return true;
        }
        if (!(paramObject instanceof DateTimeOffset)) {
            return false;
        }
        DateTimeOffset localEdmDateTimeOffset = (DateTimeOffset)paramObject;
        return this.utcMillis == localEdmDateTimeOffset.utcMillis && this.nanos == localEdmDateTimeOffset.nanos && this.minutesOffset == localEdmDateTimeOffset.minutesOffset;
    }

    public int hashCode() {
        assert (0L == this.utcMillis % 1000L);
        long l = this.utcMillis / 1000L;
        int i = 571;
        i = 2011 * i + (int)l;
        i = 3217 * i + (int)(l / 60L * 60L * 24L * 365L);
        i = 3919 * i + this.nanos / 100000;
        i = 4463 * i + this.nanos / 1000;
        i = 5227 * i + this.nanos;
        i = 6689 * i + this.minutesOffset;
        i = 7577 * i + this.minutesOffset / 60;
        return i;
    }

    public Timestamp getTimestamp() {
        Timestamp localTimestamp = new Timestamp(this.utcMillis);
        localTimestamp.setNanos(this.nanos);
        return localTimestamp;
    }

    public int getMinutesOffset() {
        return this.minutesOffset;
    }

    @Override
    public int compareTo(DateTimeOffset paramEdmDateTimeOffset) {
        assert (this.nanos >= 0);
        assert (paramEdmDateTimeOffset.nanos >= 0);
        return this.utcMillis < paramEdmDateTimeOffset.utcMillis ? -1 : (this.utcMillis > paramEdmDateTimeOffset.utcMillis ? 1 : this.nanos - paramEdmDateTimeOffset.nanos);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream paramObjectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("");
    }

    private static class SerializationProxy
    implements Serializable {
        private final long utcMillis;
        private final int nanos;
        private final int minutesOffset;
        private static final long serialVersionUID = 664661379547314226L;

        SerializationProxy(DateTimeOffset paramEdmDateTimeOffset) {
            this.utcMillis = paramEdmDateTimeOffset.utcMillis;
            this.nanos = paramEdmDateTimeOffset.nanos;
            this.minutesOffset = paramEdmDateTimeOffset.minutesOffset;
        }

        private Object readResolve() {
            Timestamp localTimestamp = new Timestamp(this.utcMillis);
            localTimestamp.setNanos(this.nanos);
            return new DateTimeOffset(localTimestamp, this.minutesOffset);
        }
    }
}

