/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.value;

import leap.lang.tostring.ToStringBuilder;
import leap.lang.value.Limit;

public class Page
extends Limit {
    protected final int index;
    protected final int size;

    public static Page limit(int size) {
        return Page.startFrom(1, size);
    }

    public static Page limit(int limit, int offset) {
        return Page.startFrom(offset + 1, limit);
    }

    public static Page startFrom(int start, int size) {
        int index = start < size ? 1 : start / size;
        int end = start + size - 1;
        return new Page(index, size, start, end);
    }

    public static Page startEnd(int start, int end) {
        return Page.startFrom(start, end - start + 1);
    }

    public static Page indexOf(int index, int size) {
        return new Page(index, size);
    }

    public Page(int index, int size) {
        super((index - 1) * size + 1, size * index);
        this.index = index;
        this.size = size;
    }

    protected Page(int index, int size, int start, int end) {
        super(start, end);
        this.index = index;
        this.size = size;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("index", this.index).append("size", this.size).append("start", this.start).append("end", this.end).toString();
    }
}

