/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.value;

public class UnsignedByte
extends Number
implements Comparable<UnsignedByte> {
    private static final long serialVersionUID = 698449810630429786L;
    public static final UnsignedByte MIN_VALUE = new UnsignedByte(0);
    public static final UnsignedByte MAX_VALUE = new UnsignedByte(255);
    private final int value;

    public static UnsignedByte valueOf(int value) {
        return new UnsignedByte(value);
    }

    public static UnsignedByte parseUnsignedByte(String value) {
        return UnsignedByte.valueOf(Integer.parseInt(value));
    }

    public UnsignedByte(int value) {
        this.value = UnsignedByte.checkBounds(value);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    private static int checkBounds(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value must be between 0 and 255");
        }
        return value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(UnsignedByte other) {
        return new Integer(this.value).compareTo(new Integer(other.value));
    }

    public int hashCode() {
        return new Integer(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UnsignedByte && ((UnsignedByte)obj).value == this.value;
    }
}

