/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import leap.lang.Charsets;
import leap.lang.Exceptions;
import leap.lang.exception.NestedIOException;
import leap.lang.io.IO;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;
import leap.lang.xml.DomDocument;
import leap.lang.xml.XmlDocument;
import leap.lang.xml.XmlException;
import leap.lang.xml.XmlReader;
import leap.lang.xml.XmlReaderStax;
import leap.lang.xml.XmlWriter;
import leap.lang.xml.XmlWriterStax;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XML {
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();

    protected XML() {
    }

    public static XmlDocument parse(String text) throws NestedIOException {
        return XML.parse(new StringReader(text));
    }

    public static XmlDocument parse(InputStream inputStream) throws NestedIOException {
        return XML.parse(new InputStreamReader(inputStream, Charsets.UTF_8));
    }

    public static XmlDocument parse(InputStream inputStream, String encoding) throws NestedIOException, UnsupportedCharsetException {
        return XML.parse(new InputStreamReader(inputStream, Charsets.forName(encoding)));
    }

    public static XmlDocument parse(InputStream inputStream, String encoding, String location) throws NestedIOException, UnsupportedCharsetException {
        return XML.parse(new InputStreamReader(inputStream, Charsets.forName(encoding)), location);
    }

    public static XmlDocument parse(Reader reader) throws NestedIOException {
        return XML.parse(reader, null);
    }

    public static XmlDocument parse(Reader reader, String location) throws NestedIOException, XmlException {
        return new DomDocument(XML.parseDocument(reader), location);
    }

    public static XmlDocument load(String resourceFile) throws NestedIOException {
        return XML.load(Resources.getResource(resourceFile));
    }

    public static XmlDocument load(File file) {
        DomDocument domDocument;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
            Document doc = XML.parseDocument(reader);
            domDocument = new DomDocument(doc, file.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                throw new NestedIOException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IO.close(reader);
                throw throwable;
            }
        }
        IO.close(reader);
        return domDocument;
    }

    public static XmlDocument load(Resource resource) throws NestedIOException {
        InputStreamReader reader = null;
        try {
            reader = resource.getInputStreamReader();
            Document doc = XML.parseDocument(reader);
            DomDocument domDocument = new DomDocument(doc, null == resource.getURL() ? null : resource.getURL().toString());
            return domDocument;
        }
        catch (IOException e) {
            throw new NestedIOException(e.getMessage(), e);
        }
        finally {
            IO.close(reader);
        }
    }

    public static XmlWriter createWriter(Writer out) {
        return XML.createStaxWriter(out);
    }

    public static XmlReader createReader(Reader in) {
        return XML.createStaxReader(in, null);
    }

    public static XmlReader createReader(String xml) {
        return XML.createStaxReader(new StringReader(xml), null);
    }

    public static XmlReader createReader(InputStream in) {
        return XML.createStaxReader(new InputStreamReader(in, Charsets.UTF_8), null);
    }

    public static XmlReader createReader(InputStream in, String encoding) {
        return XML.createStaxReader(new InputStreamReader(in, Charsets.forName(encoding)), null);
    }

    public static XmlReader createReader(File file) {
        try {
            return XML.createStaxReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8), file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
    }

    public static XmlReader createReader(Resource resource) {
        try {
            String resourceLocation = resource.toString();
            return XML.createStaxReader(new InputStreamReader(resource.getInputStream(), Charsets.UTF_8), resourceLocation);
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
    }

    public static XMLEventReader createEventReader(Reader in) {
        try {
            return factory.createXMLEventReader(in);
        }
        catch (XMLStreamException e) {
            throw new XmlException(e.getMessage(), e);
        }
    }

    static Document parseDocument(Reader reader) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            return builder.parse(new InputSource(reader));
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        catch (Exception e) {
            throw new XmlException(e.getMessage(), e);
        }
    }

    static XmlWriter createStaxWriter(Writer out) throws XmlException {
        return new XmlWriterStax(out);
    }

    static XmlReader createStaxReader(Reader in, String sourceLocation) {
        return new XmlReaderStax(in, sourceLocation);
    }

    static {
        factory.setProperty("javax.xml.stream.supportDTD", false);
    }
}

