/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.io.Closeable;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import leap.lang.Sourced;
import leap.lang.text.PlaceholderResolver;

public interface XmlReader
extends Closeable,
Sourced {
    public String getCurrentLocation();

    public XMLEvent event();

    public void setTrimAll(boolean var1);

    public boolean isTrimAll();

    public boolean next();

    default public void loopInsideElement(Runnable func) {
        QName elementName = this.getElementName();
        int elementCount = 1;
        while (this.next()) {
            if (this.isEndElement(elementName)) {
                if (elementCount == 1) {
                    return;
                }
                --elementCount;
            } else if (this.isStartElement(elementName)) {
                ++elementCount;
            }
            func.run();
        }
    }

    public boolean nextWhileNotEnd(QName var1);

    public boolean nextWhileNotEnd(String var1);

    public boolean nextToStartElement();

    public boolean nextToStartElement(String var1);

    public boolean nextToStartElement(QName var1);

    public boolean nextToEndElement();

    public boolean nextToEndElement(String var1);

    public boolean nextToEndElement(QName var1);

    public boolean isProcessingInstruction();

    public boolean isProcessingInstruction(String var1);

    public boolean isCharacters();

    public String getCharacters();

    public boolean isStartElement();

    public boolean isStartElement(QName var1);

    public boolean isStartElement(String var1);

    public boolean isEndElement();

    public boolean isEndElement(QName var1);

    public boolean isEndElement(String var1);

    public boolean isEndDocument();

    public String getProcessingInstructionTarget();

    public String getProcessingInstructionContent();

    public QName getElementName();

    public String getElementLocalName();

    public int getLineNumber();

    public String getElementTextAndEnd();

    default public Integer getIntegerElementTextAndEnd() {
        String s = this.getElementTextAndEnd();
        if (null != s && s.length() > 0) {
            return Integer.parseInt(s);
        }
        return null;
    }

    public Iterator<String> getAttributeLocalNames();

    public Iterator<QName> getAttributeNames();

    public boolean hasAttribute(QName var1);

    public boolean hasAttribute(String var1);

    public String getAttribute(QName var1);

    public String getAttribute(String var1);

    public String getAttributeOrNull(QName var1);

    public String getAttributeOrNull(String var1);

    public String getAttribute(QName var1, String var2);

    public String getAttribute(String var1, String var2);

    public <T> T getAttribute(QName var1, Class<T> var2);

    public <T> T getAttribute(String var1, Class<T> var2);

    public <T> T getAttribute(QName var1, Class<T> var2, T var3);

    public <T> T getAttribute(String var1, Class<T> var2, T var3);

    public Boolean getBooleanAttribute(QName var1);

    public Boolean getBooleanAttribute(String var1);

    public boolean getBooleanAttribute(QName var1, boolean var2);

    public boolean getBooleanAttribute(String var1, boolean var2);

    public Integer getIntegerAttribute(QName var1);

    public Integer getIntegerAttribute(String var1);

    public int getIntAttribute(QName var1, int var2);

    public int getIntAttribute(String var1, int var2);

    public Float getFloatAttribute(QName var1);

    public Float getFloatAttribute(String var1);

    public float getFloatAttribute(QName var1, float var2);

    public float getFloatAttribute(String var1, float var2);

    public String getRequiredElementTextAndEnd();

    public String getRequiredAttribute(QName var1);

    public String getRequiredAttribute(String var1);

    public <T> T getRequiredAttribute(QName var1, Class<T> var2);

    public <T> T getRequiredAttribute(String var1, Class<T> var2);

    public boolean getRequiredBooleanAttribute(QName var1);

    public boolean getRequiredBooleanAttribute(String var1);

    public int getRequiredIntAttribute(QName var1);

    public int getRequiredIntAttribute(String var1);

    public void setPlaceholderResolver(PlaceholderResolver var1);

    public PlaceholderResolver getPlaceholderResolver();

    public String resolveElementTextAndEnd();

    public String resolveAttribute(QName var1);

    public String resolveAttribute(String var1);

    public String resolveAttribute(QName var1, String var2);

    public String resolveAttribute(String var1, String var2);

    public <T> T resolveAttribute(QName var1, Class<T> var2);

    public <T> T resolveAttribute(String var1, Class<T> var2);

    public <T> T resolveAttribute(QName var1, Class<T> var2, T var3);

    public <T> T resolveAttribute(String var1, Class<T> var2, T var3);

    public Boolean resolveBooleanAttribute(QName var1);

    public Boolean resolveBooleanAttribute(String var1);

    public boolean resolveBooleanAttribute(QName var1, boolean var2);

    public boolean resolveBooleanAttribute(String var1, boolean var2);

    public Integer resolveIntegerAttribute(QName var1);

    public Integer resolveIntegerAttribute(String var1);

    public int resolveIntAttribute(QName var1, int var2);

    public int resolveIntAttribute(String var1, int var2);

    public float resolveFloatAttribute(QName var1, int var2);

    public float resolveFloatAttribute(String var1, int var2);

    public String resolveRequiredElementTextAndEnd();

    public String resolveRequiredAttribute(QName var1);

    public String resolveRequiredAttribute(String var1);

    public <T> T resolveRequiredAttribute(QName var1, Class<T> var2);

    public <T> T resolveRequiredAttribute(String var1, Class<T> var2);

    public boolean resolveRequiredBooleanAttribute(QName var1);

    public boolean resolveRequiredBooleanAttribute(String var1);

    public int resolveRequiredIntAttribute(QName var1);

    public int resolveRequiredIntAttribute(String var1);

    public void forEachResolvedAttributes(BiConsumer<QName, String> var1);

    public void forEachAttributes(BiConsumer<QName, String> var1);
}

