/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.text.PlaceholderResolver;
import leap.lang.xml.XmlReader;

public abstract class XmlReaderBase
implements XmlReader {
    protected Object source = "unknown";
    protected PlaceholderResolver placeholderResolver = null;
    protected boolean trimAll = true;

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public String getCurrentLocation() {
        return "line " + this.getLineNumber() + ", element '" + this.getElementLocalName() + "' in " + (null == this.source ? "[unknow source]" : this.source);
    }

    @Override
    public void setTrimAll(boolean trimAll) {
        this.trimAll = trimAll;
    }

    @Override
    public boolean isTrimAll() {
        return this.trimAll;
    }

    @Override
    public void setPlaceholderResolver(PlaceholderResolver placeholderResolver) {
        this.placeholderResolver = placeholderResolver;
    }

    @Override
    public PlaceholderResolver getPlaceholderResolver() {
        return this.placeholderResolver;
    }

    @Override
    public boolean nextWhileNotEnd(QName elementName) {
        if (this.isEndElement(elementName)) {
            return false;
        }
        return this.next();
    }

    @Override
    public boolean nextWhileNotEnd(String elementLocalName) {
        if (this.isEndElement(elementLocalName)) {
            return false;
        }
        return this.next();
    }

    @Override
    public boolean nextToStartElement() {
        while (this.next()) {
            if (!this.isStartElement()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextToStartElement(String localName) {
        while (this.next()) {
            if (!this.isStartElement(localName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextToStartElement(QName name) {
        while (this.next()) {
            if (!this.isStartElement(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextToEndElement() {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Must be start element");
        }
        int counter = 1;
        while (this.next()) {
            if (this.isStartElement()) {
                ++counter;
                continue;
            }
            if (this.isEndElement()) {
                --counter;
                continue;
            }
            if (counter != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextToEndElement(String localName) {
        while (this.next()) {
            if (!this.isEndElement(localName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextToEndElement(QName name) {
        while (this.next()) {
            if (!this.isEndElement(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getElementTextAndEnd() {
        String text = this.doGetElementTextAndEnd();
        return this.trimAll ? Strings.trim(text) : text;
    }

    @Override
    public String getRequiredElementTextAndEnd() {
        String value = this.getElementTextAndEnd();
        if (Strings.isEmpty(value)) {
            throw new IllegalStateException("Element text must not be empty, location: " + this.getCurrentLocation());
        }
        return value;
    }

    @Override
    public final String getAttribute(QName name) {
        String value = this.doGetAttribute(name);
        return this.trimAll ? Strings.trim(value) : value;
    }

    @Override
    public final String getAttribute(String localName) {
        String value = this.doGetAttribute(localName);
        return this.trimAll ? Strings.trim(value) : value;
    }

    @Override
    public String getAttributeOrNull(QName name) {
        String value = this.doGetAttribute(name);
        return null == value ? null : (this.trimAll ? Strings.trim(value) : value);
    }

    @Override
    public String getAttributeOrNull(String localName) {
        String value = this.doGetAttribute(localName);
        return null == value ? null : (this.trimAll ? Strings.trim(value) : value);
    }

    @Override
    public String getAttribute(QName name, String defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : value;
    }

    @Override
    public String getAttribute(String localName, String defaultValue) {
        String value = this.getAttribute(localName);
        return Strings.isEmpty(value) ? defaultValue : value;
    }

    @Override
    public String getRequiredAttribute(QName name) {
        String value = this.getAttribute(name);
        if (Strings.isEmpty(value)) {
            throw new IllegalStateException("Attribute '" + name + "' must not be empty, location : " + this.getCurrentLocation());
        }
        return value;
    }

    @Override
    public String getRequiredAttribute(String localName) {
        String value = this.getAttribute(localName);
        if (Strings.isEmpty(value)) {
            throw new IllegalStateException("Attribute '" + localName + "' must not be empty, location : " + this.getCurrentLocation());
        }
        return value;
    }

    @Override
    public <T> T getAttribute(QName name, Class<T> targetType) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? null : (T)Converts.convert(value, targetType);
    }

    @Override
    public <T> T getAttribute(String localName, Class<T> targetType) {
        String value = this.getAttribute(localName);
        return Strings.isEmpty(value) ? null : (T)Converts.convert(value, targetType);
    }

    @Override
    public <T> T getAttribute(QName name, Class<T> targetType, T defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.convert(value, targetType);
    }

    @Override
    public <T> T getAttribute(String localName, Class<T> targetType, T defaultValue) {
        String value = this.getAttribute(localName);
        return Strings.isEmpty(value) ? defaultValue : Converts.convert(value, targetType);
    }

    @Override
    public <T> T getRequiredAttribute(QName name, Class<T> targetType) {
        return Converts.convert(this.getRequiredAttribute(name), targetType);
    }

    @Override
    public <T> T getRequiredAttribute(String localName, Class<T> targetType) {
        return Converts.convert(this.getRequiredAttribute(localName), targetType);
    }

    @Override
    public Boolean getBooleanAttribute(QName name) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? null : Boolean.valueOf(Converts.toBoolean(value));
    }

    @Override
    public Boolean getBooleanAttribute(String name) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? null : Boolean.valueOf(Converts.toBoolean(value));
    }

    @Override
    public boolean getBooleanAttribute(QName name, boolean defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.toBoolean(value);
    }

    @Override
    public boolean getBooleanAttribute(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.toBoolean(value);
    }

    @Override
    public boolean getRequiredBooleanAttribute(QName name) {
        return Converts.toBoolean(this.getRequiredAttribute(name));
    }

    @Override
    public boolean getRequiredBooleanAttribute(String localName) {
        return Converts.toBoolean(this.getRequiredAttribute(localName));
    }

    @Override
    public Integer getIntegerAttribute(QName name) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? null : Integer.valueOf(Converts.toInt(value));
    }

    @Override
    public Integer getIntegerAttribute(String name) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? null : Integer.valueOf(Converts.toInt(value));
    }

    @Override
    public int getIntAttribute(QName name, int defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.toInt(value);
    }

    @Override
    public int getIntAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.toInt(value);
    }

    @Override
    public Float getFloatAttribute(QName name) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? null : Converts.convert(value, Float.class);
    }

    @Override
    public Float getFloatAttribute(String localName) {
        String value = this.getAttribute(localName);
        return Strings.isEmpty(value) ? null : Converts.convert(value, Float.class);
    }

    @Override
    public float getFloatAttribute(QName name, float defaultValue) {
        String value = this.getAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.convert(value, Float.class).floatValue();
    }

    @Override
    public float getFloatAttribute(String localName, float defaultValue) {
        String value = this.getAttribute(localName);
        return Strings.isEmpty(value) ? defaultValue : Converts.convert(value, Float.class).floatValue();
    }

    @Override
    public int getRequiredIntAttribute(QName name) {
        return Converts.toInt(this.getRequiredAttribute(name));
    }

    @Override
    public int getRequiredIntAttribute(String localName) {
        return Converts.toInt(this.getRequiredAttribute(localName));
    }

    private final String resolve(String value) {
        return null == this.placeholderResolver ? value : this.placeholderResolver.resolveString(value);
    }

    @Override
    public String resolveElementTextAndEnd() {
        return this.resolve(this.getElementTextAndEnd());
    }

    @Override
    public String resolveRequiredElementTextAndEnd() {
        return this.resolve(this.getRequiredElementTextAndEnd());
    }

    @Override
    public String resolveAttribute(QName name) {
        return this.resolve(this.getAttribute(name));
    }

    @Override
    public String resolveAttribute(String localName) {
        return this.resolve(this.getAttribute(localName));
    }

    @Override
    public String resolveAttribute(QName name, String defaultValue) {
        return this.resolve(this.getAttribute(name, defaultValue));
    }

    @Override
    public String resolveAttribute(String localName, String defaultValue) {
        return this.resolve(this.getAttribute(localName, defaultValue));
    }

    @Override
    public String resolveRequiredAttribute(QName name) {
        return this.resolve(this.getRequiredAttribute(name));
    }

    @Override
    public String resolveRequiredAttribute(String localName) {
        return this.resolve(this.getRequiredAttribute(localName));
    }

    @Override
    public <T> T resolveAttribute(QName name, Class<T> targetType) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? null : (T)Converts.convert(value, targetType);
    }

    @Override
    public <T> T resolveAttribute(String localName, Class<T> targetType) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? null : (T)Converts.convert(value, targetType);
    }

    @Override
    public <T> T resolveAttribute(QName name, Class<T> targetType, T defaultValue) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.convert(value, targetType);
    }

    @Override
    public <T> T resolveAttribute(String localName, Class<T> targetType, T defaultValue) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? defaultValue : Converts.convert(value, targetType);
    }

    @Override
    public <T> T resolveRequiredAttribute(QName name, Class<T> targetType) {
        return Converts.convert(this.resolveRequiredAttribute(name), targetType);
    }

    @Override
    public <T> T resolveRequiredAttribute(String localName, Class<T> targetType) {
        return Converts.convert(this.resolveRequiredAttribute(localName), targetType);
    }

    @Override
    public Boolean resolveBooleanAttribute(QName name) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? null : Boolean.valueOf(Converts.toBoolean(value));
    }

    @Override
    public Boolean resolveBooleanAttribute(String localName) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? null : Boolean.valueOf(Converts.toBoolean(value));
    }

    @Override
    public boolean resolveBooleanAttribute(QName name, boolean defaultValue) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.toBoolean(value);
    }

    @Override
    public boolean resolveBooleanAttribute(String localName, boolean defaultValue) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? defaultValue : Converts.toBoolean(value);
    }

    @Override
    public boolean resolveRequiredBooleanAttribute(QName name) {
        return Converts.toBoolean(this.resolveRequiredAttribute(name));
    }

    @Override
    public boolean resolveRequiredBooleanAttribute(String localName) {
        return Converts.toBoolean(this.resolveRequiredAttribute(localName));
    }

    @Override
    public Integer resolveIntegerAttribute(QName name) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? null : Integer.valueOf(Converts.toInt(value));
    }

    @Override
    public Integer resolveIntegerAttribute(String localName) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? null : Integer.valueOf(Converts.toInt(value));
    }

    @Override
    public int resolveIntAttribute(QName name, int defaultValue) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? defaultValue : Converts.toInt(value);
    }

    @Override
    public int resolveIntAttribute(String localName, int defaultValue) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? defaultValue : Converts.toInt(value);
    }

    @Override
    public float resolveFloatAttribute(QName name, int defaultValue) {
        String value = this.resolveAttribute(name);
        return Strings.isEmpty(value) ? (float)defaultValue : Converts.convert(value, Float.class).floatValue();
    }

    @Override
    public float resolveFloatAttribute(String localName, int defaultValue) {
        String value = this.resolveAttribute(localName);
        return Strings.isEmpty(value) ? (float)defaultValue : Converts.convert(value, Float.class).floatValue();
    }

    @Override
    public int resolveRequiredIntAttribute(QName name) {
        return Converts.toInt(this.resolveRequiredAttribute(name));
    }

    @Override
    public int resolveRequiredIntAttribute(String localName) {
        return Converts.toInt(this.resolveRequiredAttribute(localName));
    }

    @Override
    public void forEachResolvedAttributes(BiConsumer<QName, String> func) {
        Iterator<QName> names = this.getAttributeNames();
        while (names.hasNext()) {
            QName name = names.next();
            String value = this.resolveAttribute(name);
            func.accept(name, value);
        }
    }

    @Override
    public void forEachAttributes(BiConsumer<QName, String> func) {
        Iterator<QName> names = this.getAttributeNames();
        while (names.hasNext()) {
            QName name = names.next();
            String value = this.getAttribute(name);
            func.accept(name, value);
        }
    }

    protected abstract String doGetElementTextAndEnd();

    protected abstract String doGetAttribute(QName var1);

    protected abstract String doGetAttribute(String var1);
}

