/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.XMLEvent;
import leap.lang.io.IO;
import leap.lang.xml.XML;
import leap.lang.xml.XmlException;
import leap.lang.xml.XmlReader;
import leap.lang.xml.XmlReaderBase;

final class XmlReaderStax
extends XmlReaderBase
implements XmlReader {
    private final Reader in;
    private final XMLEventReader real;
    private XMLEvent event;

    public XmlReaderStax(Reader in) {
        this(in, null);
    }

    public XmlReaderStax(Reader in, String sourceLocation) {
        this.in = in;
        this.real = XML.createEventReader(in);
        if (null != sourceLocation) {
            this.source = sourceLocation;
        }
    }

    @Override
    public XMLEvent event() {
        return this.event;
    }

    @Override
    public boolean isCharacters() {
        return this.event.isCharacters();
    }

    @Override
    public String getCharacters() {
        return this.event.asCharacters().getData();
    }

    @Override
    public boolean isEndElement() {
        return null != this.event && this.event.isEndElement();
    }

    @Override
    public boolean isEndElement(QName name) {
        return this.isEndElement() && this.event.asEndElement().getName().equals(name);
    }

    @Override
    public boolean isProcessingInstruction() {
        return null != this.event && this.event.isProcessingInstruction();
    }

    @Override
    public boolean isProcessingInstruction(String target) {
        return this.isProcessingInstruction() && this.getProcessingInstructionTarget().equals(target);
    }

    @Override
    public boolean isStartElement() {
        return null != this.event && this.event.isStartElement();
    }

    @Override
    public boolean isStartElement(QName name) {
        return this.isStartElement() && this.event.asStartElement().getName().equals(name);
    }

    @Override
    public boolean isStartElement(String name) {
        return this.isStartElement() && this.event.asStartElement().getName().getLocalPart().equals(name);
    }

    @Override
    public boolean isEndElement(String name) {
        return this.isEndElement() && this.event.asEndElement().getName().getLocalPart().equals(name);
    }

    @Override
    public boolean isEndDocument() {
        return null != this.event && this.event.isEndDocument();
    }

    @Override
    public String getProcessingInstructionTarget() {
        return ((ProcessingInstruction)this.event).getTarget();
    }

    @Override
    public String getProcessingInstructionContent() {
        return ((ProcessingInstruction)this.event).getData();
    }

    @Override
    public QName getElementName() {
        return this.event.asStartElement().getName();
    }

    @Override
    public String getElementLocalName() {
        return this.event.asStartElement().getName().getLocalPart();
    }

    @Override
    public Iterator<String> getAttributeLocalNames() {
        final Iterator<Attribute> it = this.event.asStartElement().getAttributes();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public String next() {
                Attribute a = (Attribute)it.next();
                return a.getName().getLocalPart();
            }
        };
    }

    @Override
    public Iterator<QName> getAttributeNames() {
        final Iterator<Attribute> it = this.event.asStartElement().getAttributes();
        return new Iterator<QName>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public QName next() {
                Attribute a = (Attribute)it.next();
                return a.getName();
            }
        };
    }

    @Override
    public boolean hasAttribute(QName name) {
        return null == this.event ? false : this.event.asStartElement().getAttributeByName(name) != null;
    }

    @Override
    public boolean hasAttribute(String localName) {
        if (null == this.event) {
            return false;
        }
        Iterator<Attribute> attrs = this.event.asStartElement().getAttributes();
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            if (!attr.getName().getLocalPart().equals(localName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String doGetElementTextAndEnd() {
        try {
            return this.real.getElementText();
        }
        catch (XMLStreamException e) {
            throw new XmlException(e.getMessage(), e);
        }
    }

    @Override
    public String doGetAttribute(QName name) {
        Attribute attr = this.attr(name);
        return attr == null ? null : attr.getValue();
    }

    @Override
    public String doGetAttribute(String name) {
        if (null == this.event) {
            return null;
        }
        Iterator<Attribute> attrs = this.event.asStartElement().getAttributes();
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            if (!attr.getName().getLocalPart().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    @Override
    public boolean next() {
        try {
            if (this.real.hasNext()) {
                this.event = this.real.nextEvent();
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new XmlException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws IOException {
        IO.close(this.in);
        try {
            this.real.close();
        }
        catch (XMLStreamException e) {
            throw new XmlException(e.getMessage(), e);
        }
    }

    @Override
    public int getLineNumber() {
        return null == this.event ? -1 : this.event.getLocation().getLineNumber();
    }

    private Attribute attr(QName name) {
        return null == this.event ? null : this.event.asStartElement().getAttributeByName(name);
    }

    public String toString() {
        return null == this.event ? "No event" : this.event.getClass().getSimpleName() + " : " + this.event.toString();
    }
}

