/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.util.Iterator;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import leap.lang.Enumerable;
import leap.lang.Strings;
import leap.lang.collection.UnmodifiableIteratorBase;
import leap.lang.xml.XmlNamed;
import org.w3c.dom.Element;

final class XmlUtils {
    XmlUtils() {
    }

    static String getElementText(Element element) {
        return element.getTextContent();
    }

    public static String escapeAttributeValue(String unescaped) {
        return XmlUtils.escapeElementValue(unescaped);
    }

    public static String escapeElementValue(String unescaped) {
        return unescaped.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("\"", "&quot;");
    }

    static final class Predicates {
        Predicates() {
        }

        public static Predicate<String> endsWith(final String suffix) {
            return new Predicate<String>(){

                @Override
                public boolean test(String input) {
                    return input.endsWith(suffix);
                }
            };
        }

        public static Predicate<String> startsWith(final String prefix) {
            return new Predicate<String>(){

                @Override
                public boolean test(String input) {
                    return input.startsWith(prefix);
                }
            };
        }

        public static <T extends XmlNamed> Predicate<T> xnameEquals(final XmlNamed xname) {
            return new Predicate<T>(){

                @Override
                public boolean test(T input) {
                    return Strings.equals(xname.prefix(), input.prefix()) && Strings.equals(xname.name(), input.name());
                }
            };
        }

        public static <T extends XmlNamed> Predicate<T> xnameEquals(final String name) {
            return new Predicate<T>(){

                @Override
                public boolean test(T input) {
                    return Strings.equals(input.name(), name);
                }
            };
        }

        public static <T extends XmlNamed> Predicate<T> xnameEqualsWithPrefix(final String name) {
            return new Predicate<T>(){

                @Override
                public boolean test(T input) {
                    return !Strings.isEmpty(input.prefix()) && Strings.equals(input.name(), name);
                }
            };
        }

        public static <T extends XmlNamed> Predicate<T> xnameEquals(final String prefix, final String name) {
            return new Predicate<T>(){

                @Override
                public boolean test(T input) {
                    return Strings.equals(prefix, input.prefix()) && Strings.equals(input.name(), name);
                }
            };
        }

        public static <T> Predicate<T> not(final Predicate<T> predicate) {
            return new Predicate<T>(){

                @Override
                public boolean test(T input) {
                    return !predicate.test(input);
                }
            };
        }
    }

    static class DepthFirstIterator<T>
    extends UnmodifiableIteratorBase<T> {
        private final Function<T, Enumerable<T>> childrenFn;
        private final Stack<T> stack = new Stack();

        public DepthFirstIterator(T startingNode, Function<T, Enumerable<T>> childrenFn) {
            this.childrenFn = childrenFn;
            this.stack.add(startingNode);
        }

        @Override
        protected T computeNext() {
            Iterator iterator = this.childrenFn.apply(this.stack.peek()).iterator();
            if (iterator.hasNext()) {
                Object child = iterator.next();
                this.stack.push(child);
                return child;
            }
            while (this.stack.size() > 1) {
                T currentNode = this.stack.pop();
                boolean foundSelf = false;
                for (Object sibling : this.childrenFn.apply(this.stack.peek())) {
                    if (foundSelf) {
                        this.stack.push(sibling);
                        return sibling;
                    }
                    if (!sibling.equals(currentNode)) continue;
                    foundSelf = true;
                }
            }
            return this.endOfData();
        }
    }
}

