/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import leap.lang.Charsets;
import leap.lang.Exceptions;
import leap.lang.Strings;
import leap.lang.exception.NestedIOException;
import leap.lang.resource.Resource;
import leap.lang.xml.DomDocument;
import leap.lang.xml.XmlException;
import leap.lang.xml.XmlValidationException;
import org.xml.sax.SAXException;

public class XmlValidator {
    private Schema schema;

    public static XmlValidator of(Resource schemaResource) throws NestedIOException {
        try {
            return XmlValidator.of(schemaResource.getInputStream());
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static XmlValidator of(InputStream schemaStream) throws NestedIOException {
        return XmlValidator.of(new InputStreamReader(schemaStream, Charsets.UTF_8));
    }

    public static XmlValidator of(Reader schemaReader) throws NestedIOException, XmlException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource source = new StreamSource(schemaReader);
            Schema schema = factory.newSchema(source);
            return new XmlValidator(schema);
        }
        catch (SAXException e) {
            throw new XmlException(Strings.format("Error create validator from schema : {0}", e.getMessage()), e);
        }
    }

    protected XmlValidator(Schema schema) {
        this.schema = schema;
    }

    public void validate(DomDocument doc) throws XmlValidationException, NestedIOException {
        Validator validator = this.schema.newValidator();
        try {
            Source source = null;
            source = null != doc.domDocument() ? new DOMSource(doc.domDocument()) : new StreamSource(new StringReader(doc.toXml()));
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new XmlValidationException(Strings.format("Error validating xml : {0} \n {1}", e.getMessage(), doc.location()), e);
        }
        catch (IOException e) {
            throw Exceptions.uncheck(e);
        }
    }
}

