/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.xml;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import leap.lang.io.IO;
import leap.lang.xml.XmlException;
import leap.lang.xml.XmlWriter;
import leap.lang.xml.XmlWriterBase;

class XmlWriterStax
extends XmlWriterBase {
    private static XMLOutputFactory factory = XMLOutputFactory.newInstance();
    private final Writer out;
    private final XMLStreamWriter writer;

    XmlWriterStax(Writer out) {
        try {
            this.out = out;
            this.writer = factory.createXMLStreamWriter(out);
        }
        catch (Exception e) {
            throw new XmlException("Error create XMLStreamWriter : " + e.getMessage(), e);
        }
    }

    @Override
    public XmlWriter startDocument() {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter startDocument(String version) {
        try {
            this.writer.writeStartDocument(version);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter startDocument(String version, String encoding) {
        try {
            this.writer.writeStartDocument(version, encoding);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter startElement(String localName) {
        try {
            this.writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter startElement(String namespaceURI, String localName) {
        try {
            this.writer.writeStartElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter startElement(String prefix, String namespaceURI, String localName) {
        try {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter emptyElement(String localName) {
        try {
            this.writer.writeEmptyElement(localName);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter emptyElement(String namespaceURI, String localName) {
        try {
            this.writer.writeEmptyElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter emptyElement(String prefix, String namespaceURI, String localName) {
        try {
            this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter namespace(String namespaceURI) {
        try {
            this.writer.writeDefaultNamespace(namespaceURI);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter namespace(String prefix, String namespaceURI) {
        try {
            this.writer.writeNamespace(prefix, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter attribute(String localName, String value) {
        try {
            this.writer.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter attribute(String namespaceURI, String localName, String value) {
        try {
            this.writer.writeAttribute(namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter attribute(String prefix, String namespaceURI, String localName, String value) {
        try {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter text(String text) {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter text(String text, boolean escape) {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter cdata(String text) {
        try {
            this.writer.writeCData(text);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter comment(String comment) {
        try {
            this.writer.writeComment(comment);
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter endElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter endDocument() {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public XmlWriter flush() {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        IO.close(this.out);
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw XmlWriterStax.wrap(e);
        }
    }

    private static XmlException wrap(XMLStreamException e) {
        return new XmlException(e.getMessage(), e);
    }
}

