/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.yaml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.lang.yaml.Event;
import leap.lang.yaml.EventType;
import leap.lang.yaml.Parser;
import leap.lang.yaml.ScalarEvent;

class YamlDecoder {
    private Parser parser;
    private Event event;
    private EventType type;
    private List<Object> values = new ArrayList<Object>();

    public YamlDecoder(Reader reader) {
        this.parser = new Parser(reader);
        this.next();
    }

    public Object decode() {
        if (this.event == null) {
            throw new IllegalStateException("null event");
        }
        do {
            if (this.type == EventType.STREAM_START) continue;
            if (this.type == EventType.STREAM_END) break;
            if (this.type == EventType.DOCUMENT_START || this.type == EventType.DOCUMENT_END) continue;
            this.values.add(this.readValue());
        } while (this.next());
        if (this.values.size() == 0) {
            return null;
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        return this.values;
    }

    private Object readValue() {
        EventType type = this.event.type;
        if (type == EventType.MAPPING_START) {
            return this.readMap();
        }
        if (type == EventType.SEQUENCE_START) {
            return this.readList();
        }
        if (type == EventType.SCALAR) {
            return this.readScalarValue();
        }
        throw new IllegalStateException("Illegal yaml event : " + (Object)((Object)type));
    }

    private Map<String, Object> readMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (this.expectNext() && this.type != EventType.MAPPING_END) {
            if (this.type == EventType.SCALAR) {
                String key = ((ScalarEvent)this.event).value;
                this.expectNext();
                map.put(key, this.readValue());
                continue;
            }
            throw new IllegalStateException("Illegal yaml mapping event : " + (Object)((Object)this.type));
        }
        return map;
    }

    private List<Object> readList() {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.expectNext() && this.type != EventType.SEQUENCE_END) {
            list.add(this.readValue());
        }
        return list;
    }

    private Object readScalarValue() {
        ScalarEvent scalar = (ScalarEvent)this.event;
        return scalar.value;
    }

    private boolean next() {
        this.event = this.parser.getNextEvent();
        this.type = null == this.event ? null : this.event.type;
        return null != this.event;
    }

    private boolean expectNext() {
        if (!this.next()) {
            throw new IllegalStateException("Illegal yaml event, expect next event");
        }
        return true;
    }
}

