/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.yaml;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.yaml.YamlCollection;
import leap.lang.yaml.YamlValue;

public class YamlObject
implements YamlValue {
    private final Map map;

    public YamlObject(Map map) {
        this.map = map;
    }

    @Override
    public Object raw() {
        return this.map;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.map;
    }

    @Override
    public YamlObject asYamlObject() {
        return this;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public Collection<Object> values() {
        return this.map.values();
    }

    public boolean hasProperties() {
        return this.map.isEmpty();
    }

    public boolean hasProperty(String key) {
        return this.map.containsKey(key);
    }

    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    public <T> T get(String key, Class<T> type) {
        return Converts.convert(this.map.get(key), type);
    }

    public YamlValue getValue(String key) {
        Object o = this.get(key);
        return null == o ? null : YamlValue.of(o);
    }

    public YamlCollection getArray(String key) {
        List list = (List)this.get(key);
        return null == list ? null : new YamlCollection(list);
    }

    public YamlObject getObject(String key) {
        Map map = (Map)this.get(key);
        return null == map ? null : new YamlObject(map);
    }

    public String getString(String key) {
        return (String)this.map.get(key);
    }

    public String getString(String key, String defaultValue) {
        String s = (String)this.map.get(key);
        return Strings.isEmpty(s) ? defaultValue : s;
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Integer i = (Integer)this.get(key);
        return null == i ? defaultValue : i;
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Long getLong(String key, Long defaultValue) {
        Long l = (Long)this.get(key);
        return null == l ? defaultValue : l;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean b = (Boolean)this.get(key);
        return null == b ? defaultValue : b;
    }

    public Float getFloat(String key) {
        return (Float)this.get(key);
    }

    public Float getFloat(String key, Float defaultValue) {
        Float f = (Float)this.get(key);
        return null == f ? defaultValue : f;
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        Double d = (Double)this.get(key);
        return null == d ? defaultValue : d;
    }

    public String toString() {
        return this.map.toString();
    }
}

