/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.yaml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import leap.lang.exception.NestedIOException;
import leap.lang.yaml.Event;
import leap.lang.yaml.EventType;
import leap.lang.yaml.Parser;
import leap.lang.yaml.ScalarEvent;
import leap.lang.yaml.YamlException;

public class YamlProperties
extends LinkedHashMap<String, String> {
    private static final long serialVersionUID = -7395941062458585097L;
    private Parser parser;
    private Event event;

    public static YamlProperties read(String content) throws YamlException {
        try {
            return new YamlProperties(new StringReader(content));
        }
        catch (IOException e) {
            throw new NestedIOException(e);
        }
    }

    public static YamlProperties read(Reader reader) throws IOException, YamlException {
        return new YamlProperties(reader);
    }

    private YamlProperties(Reader reader) throws IOException {
        this.parser = new Parser(reader);
        this.parse();
    }

    private void parse() throws IOException {
        while (this.next()) {
            if (this.event.type == EventType.STREAM_START || this.event.type == EventType.DOCUMENT_START || this.event.type == EventType.DOCUMENT_END) continue;
            if (this.event.type == EventType.STREAM_END) break;
            if (this.event.type == EventType.MAPPING_START) {
                this.readProperties("");
                continue;
            }
            throw new IllegalStateException("Not a valid yaml properties content, event : " + this.event);
        }
    }

    private void readProperties(String prefix) {
        while (this.next() && this.event.type != EventType.MAPPING_END) {
            if (this.event.type != EventType.SCALAR) continue;
            String key = prefix + ((ScalarEvent)this.event).value;
            this.next();
            this.readProperty(key);
        }
    }

    private void readProperty(String key) {
        if (this.event.type == EventType.SCALAR) {
            this.put(key, ((ScalarEvent)this.event).value);
            return;
        }
        if (this.event.type == EventType.MAPPING_START) {
            this.readProperties(key + ".");
            return;
        }
        throw new IllegalStateException("Not a valid yaml properties content, must be scalar value or nested mappings, event : " + this.event);
    }

    private boolean next() {
        this.event = this.parser.getNextEvent();
        return null != this.event;
    }
}

