/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.yaml;

import java.util.List;
import java.util.Map;
import leap.lang.yaml.YamlCollection;
import leap.lang.yaml.YamlObject;
import leap.lang.yaml.YamlScalar;

public interface YamlValue {
    public static final YamlValue NULL = () -> null;

    public static YamlValue of(Object raw) {
        if (null == raw) {
            return NULL;
        }
        if (raw instanceof YamlValue) {
            return (YamlValue)raw;
        }
        if (raw instanceof Map) {
            return new YamlObject((Map)raw);
        }
        if (raw instanceof List) {
            return new YamlCollection((List)raw);
        }
        return new YamlScalar(raw);
    }

    public Object raw();

    default public boolean isNull() {
        return null == this.raw();
    }

    default public boolean isScalar() {
        return false;
    }

    default public boolean isArray() {
        return this.raw() instanceof List;
    }

    default public boolean isMap() {
        return this.raw() instanceof Map;
    }

    default public Object[] asArray() {
        return this.asList().toArray();
    }

    default public List<Object> asList() {
        throw new IllegalStateException("Not a list");
    }

    default public Map<String, Object> asMap() {
        throw new IllegalStateException("Not a map");
    }

    default public YamlCollection asYamlCollection() {
        throw new IllegalStateException("Not a yaml collection");
    }

    default public YamlObject asYamlObject() {
        throw new IllegalStateException("Not a yaml object");
    }

    default public YamlScalar asYamlScalar() {
        throw new IllegalStateException("Not a scalar value");
    }
}

