/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.VaadinSession;
import org.linkki.core.ui.converters.LinkkiConverterRegistry;
import org.linkki.framework.ui.application.ApplicationConfig;
import org.linkki.framework.ui.application.ApplicationFooter;
import org.linkki.framework.ui.application.ApplicationHeader;

@JsModule.Container(value={@JsModule(value="./src/focus-first-item-combo-box-mixin.js"), @JsModule(value="./src/focus-first-item-combo-box-scroller.js")})
@CssImport.Container(value={@CssImport(value="./styles/linkki-application-layout.css"), @CssImport(value="./styles/linkki-vaadin-field.css", themeFor="vaadin-*")})
public abstract class ApplicationLayout
extends VerticalLayout
implements RouterLayout {
    private static final long serialVersionUID = 1L;
    private final VerticalLayout mainArea = new VerticalLayout();

    protected ApplicationLayout(ApplicationConfig config) {
        this.setMargin(false);
        this.setSpacing(false);
        this.setPadding(false);
        this.setSizeFull();
        UI.getCurrent().getElement().getThemeList().addAll(config.getDefaultVariants());
        ApplicationHeader header = config.getHeaderDefinition().create(config.getApplicationInfo(), config.getMenuItemDefinitions());
        header.init();
        this.add(new Component[]{header});
        this.mainArea.setPadding(false);
        this.mainArea.setMargin(false);
        this.mainArea.setSpacing(false);
        this.mainArea.setSizeFull();
        this.mainArea.addClassName("linkki-main-area");
        this.add(new Component[]{this.mainArea});
        this.setFlexGrow(1.0, new HasElement[]{this.mainArea});
        config.getFooterDefinition().ifPresent(fd -> {
            ApplicationFooter footer = fd.create(config.getApplicationInfo());
            footer.init();
            this.add(new Component[]{footer});
        });
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession != null) {
            vaadinSession.setAttribute(LinkkiConverterRegistry.class, (Object)config.getConverterRegistry());
            vaadinSession.setErrorHandler(config.getErrorHandler());
        }
    }

    public void showRouterLayoutContent(HasElement content) {
        if (content != null) {
            this.mainArea.getElement().appendChild(new Element[]{content.getElement()});
        } else {
            this.mainArea.getElement().removeAllChildren();
        }
    }

    public void removeRouterLayoutContent(HasElement oldContent) {
        this.mainArea.getElement().removeAllChildren();
    }
}

