/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import java.io.Serializable;
import org.linkki.framework.ui.application.ApplicationHeader;
import org.linkki.framework.ui.application.ApplicationInfo;
import org.linkki.framework.ui.application.menu.ApplicationMenuItemDefinition;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.Sequence;

public abstract class UserAwareApplicationHeader
extends ApplicationHeader {
    private static final long serialVersionUID = 1L;
    private static final String APPMENU_USER_ID = "appmenu-user";
    private static final String APPMENU_LOGOUT_ID = "appmenu-logout";
    private static final String LOGOUT = "logout";
    private static final String APPLICATIONHEADER_LOGOUT = "ApplicationHeader.Logout";

    protected UserAwareApplicationHeader(ApplicationInfo applicationInfo, Sequence<ApplicationMenuItemDefinition> menuItemDefinitions) {
        super(applicationInfo, menuItemDefinitions);
    }

    public abstract String getUsername();

    @Override
    protected MenuBar createRightMenuBar() {
        MenuBar menuBar = super.createRightMenuBar();
        this.addUserMenu(menuBar);
        return menuBar;
    }

    protected MenuItem addUserMenu(MenuBar parent) {
        MenuItem userMenu = parent.addItem((Component)VaadinIcon.USER.create());
        userMenu.add(this.getUsername());
        userMenu.setId(APPMENU_USER_ID);
        this.addUserMenuItems(userMenu);
        return userMenu;
    }

    protected void addUserMenuItems(MenuItem userMenu) {
        MenuItem logoutMenuItem = ((SubMenu)userMenu.getSubMenu()).addItem(NlsText.getString(APPLICATIONHEADER_LOGOUT), this.newLogoutCommand());
        logoutMenuItem.setId(APPMENU_LOGOUT_ID);
    }

    protected ComponentEventListener<ClickEvent<MenuItem>> newLogoutCommand() {
        return (ComponentEventListener & Serializable)e -> this.getUI().ifPresent(ui -> ui.getPage().setLocation(this.getLogoutUrl()));
    }

    protected String getLogoutUrl() {
        return this.getUI().map(ui -> ui.getInternals().getContextRootRelativePath() + LOGOUT).orElse("");
    }
}

