/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application.menu;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.dom.ThemeList;
import java.io.Serializable;
import org.linkki.framework.ui.application.menu.ApplicationMenu;
import org.linkki.framework.ui.application.menu.ApplicationMenuItemDefinition;
import org.linkki.util.handler.Handler;

public class ThemeVariantToggleMenuItemDefinition
extends ApplicationMenuItemDefinition {
    public static final ThemeVariantToggleMenuItemDefinition LUMO_DARK = new ThemeVariantToggleMenuItemDefinition("Dark Theme", "appmenu-theme-dark", "dark");
    public static final ThemeVariantToggleMenuItemDefinition LINKKI_CARD = new ThemeVariantToggleMenuItemDefinition("Card Theme", "appmenu-theme-card", "card-sections");
    public static final ThemeVariantToggleMenuItemDefinition LINKKI_COMPACT = new ThemeVariantToggleMenuItemDefinition("Compact Theme", "appmenu-theme-compact", "compact");
    public static final ThemeVariantToggleMenuItemDefinition FORM_ITEM_LABEL_START = new ThemeVariantToggleMenuItemDefinition("Label Alignment Start Theme", "appmenu-theme-label-start", "form-item-label-start");
    private final String variantName;

    public ThemeVariantToggleMenuItemDefinition(String name, String id, String variantName) {
        super(name, id, Handler.NOP_HANDLER);
        this.variantName = variantName;
    }

    @Override
    public MenuItem createItem(SubMenu subMenu) {
        MenuItem createdItem = super.createItem(subMenu);
        createdItem.setCheckable(true);
        createdItem.setChecked(UI.getCurrent().getElement().getThemeList().contains((Object)this.variantName));
        return this.toggleThemeOnClick(createdItem);
    }

    @Override
    public MenuItem createItem(ApplicationMenu menuBar) {
        return this.toggleThemeOnClick(super.createItem(menuBar));
    }

    private MenuItem toggleThemeOnClick(MenuItem createdItem) {
        createdItem.addClickListener((ComponentEventListener & Serializable)event -> this.toggleTheme((MenuItem)event.getSource()));
        return createdItem;
    }

    void toggleTheme(MenuItem createdItem) {
        ThemeList themeList = UI.getCurrent().getElement().getThemeList();
        if (themeList.contains((Object)this.variantName)) {
            themeList.remove((Object)this.variantName);
        } else {
            themeList.add((Object)this.variantName);
        }
        if (createdItem.isCheckable()) {
            createdItem.setChecked(UI.getCurrent().getElement().getThemeList().contains((Object)this.variantName));
        }
    }
}

