/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.VaadinService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.linkki.core.ui.ComponentStyles;
import org.linkki.framework.ui.dialogs.IdErrorEvent;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.handler.Handler;

public class ErrorDialogConfiguration {
    private final Handler handler;
    private String caption = NlsText.getString("DefaultErrorHandler.errorDialogTitle");
    private String errorMessage = NlsText.getString("DefaultErrorHandler.errorDialogText");
    private boolean showExceptionMessage = ErrorDialogConfiguration.isDevelopmentMode();
    private boolean showExceptionStacktrace = ErrorDialogConfiguration.isDevelopmentMode();

    private ErrorDialogConfiguration(Handler handler) {
        this.handler = handler;
    }

    public static ErrorDialogConfiguration createWithHandlerNavigatingTo(String view) {
        return new ErrorDialogConfiguration(() -> ErrorDialogConfiguration.navigateToStartView(view));
    }

    private static void navigateToStartView(String startView) {
        UI.getCurrent().navigate(startView, QueryParameters.fromString((String)"errorOccurred"));
    }

    private static boolean isDevelopmentMode() {
        return !VaadinService.getCurrent().getDeploymentConfiguration().isProductionMode();
    }

    public ErrorDialogConfiguration withCaption(String dialogCaption) {
        this.caption = dialogCaption;
        return this;
    }

    public ErrorDialogConfiguration withErrorMessage(String message) {
        this.errorMessage = message;
        return this;
    }

    public ErrorDialogConfiguration showExceptionMessage() {
        this.showExceptionMessage = true;
        return this;
    }

    public ErrorDialogConfiguration hideExceptionMessage() {
        this.showExceptionMessage = false;
        return this;
    }

    public ErrorDialogConfiguration showExceptionStacktrace() {
        this.showExceptionStacktrace = true;
        return this;
    }

    public ErrorDialogConfiguration hideExceptionStacktrace() {
        this.showExceptionStacktrace = false;
        return this;
    }

    public Handler getConfirmationHandler() {
        return this.handler;
    }

    public String getCaption() {
        return this.caption;
    }

    public List<Component> getDialogContent(ErrorEvent event) {
        Throwable throwable = event.getThrowable();
        ArrayList<Component> content = new ArrayList<Component>();
        content.add((Component)this.createErrorMessage());
        content.add(this.createErrorDetails(event));
        if (this.showExceptionMessage) {
            content.add((Component)this.createExceptionMessage(throwable));
        }
        if (this.showExceptionStacktrace) {
            content.add((Component)this.createExceptionStacktrace(throwable));
        }
        return content;
    }

    private Component createErrorDetails(ErrorEvent event) {
        String string;
        String formattedTimestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern(NlsText.getString("DefaultErrorHandler.timestampFormat")));
        if (event instanceof IdErrorEvent) {
            IdErrorEvent idErrorEvent = (IdErrorEvent)event;
            string = idErrorEvent.getExceptionId();
        } else {
            string = "no ID";
        }
        String exceptionId = string;
        return new Span(NlsText.format("DefaultErrorHandler.errorDialogTimestamp", formattedTimestamp, exceptionId));
    }

    private Span createErrorMessage() {
        return new Span(this.errorMessage);
    }

    private TextField createExceptionMessage(Throwable exception) {
        TextField textField = new TextField(NlsText.getString("DefaultErrorHandler.errorDialogDescription"));
        textField.setValue(ExceptionUtils.getRootCauseMessage((Throwable)exception));
        this.formatTextComponent(textField);
        return textField;
    }

    private TextArea createExceptionStacktrace(Throwable exception) {
        TextArea textArea = new TextArea(NlsText.getString("DefaultErrorHandler.errorDialogDetails"));
        textArea.setValue(ExceptionUtils.getStackTrace((Throwable)exception));
        textArea.setHeight("25em");
        this.formatTextComponent(textArea);
        ComponentStyles.setOverflowAuto((Component)textArea);
        return textArea;
    }

    private <T extends HasValueAndElement<?, ?> & HasSize> void formatTextComponent(T textComponent) {
        textComponent.setReadOnly(true);
        ((HasSize)textComponent).setWidthFull();
        ((HasSize)textComponent).setMinWidth("65em");
    }
}

