/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.binding.dispatcher;

import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.valueset.ValueSet;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.modelobject.ModelObjects;
import org.linkki.core.binding.descriptor.property.BoundProperty;
import org.linkki.core.binding.dispatcher.AbstractPropertyDispatcherDecorator;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.uiframework.UiFramework;

public class IpsPropertyDispatcher
extends AbstractPropertyDispatcherDecorator {
    private final WeakHashMap<Class<?>, Optional<ModelElement>> modelElementCache = new WeakHashMap(2, 1.0f);
    private final Supplier<?> modelObjectSupplier;
    private final Supplier<Class<?>> modelObjectClassSupplier;
    private final String modelAttribute;

    @Deprecated(since="2.5.0")
    public IpsPropertyDispatcher(Supplier<?> modelObjectSupplier, String modelAttribute, PropertyDispatcher wrappedDispatcher) {
        this(modelObjectSupplier, () -> null, modelAttribute, wrappedDispatcher);
    }

    public IpsPropertyDispatcher(Supplier<?> modelObjectSupplier, Supplier<Class<?>> modelObjectClassSupplier, String modelAttribute, PropertyDispatcher wrappedDispatcher) {
        super(wrappedDispatcher);
        this.modelObjectSupplier = modelObjectSupplier;
        this.modelObjectClassSupplier = modelObjectClassSupplier;
        this.modelAttribute = modelAttribute;
    }

    public <T> T pull(Aspect<T> aspect) {
        if (aspect.isValuePresent()) {
            Object staticValue = aspect.getValue();
            if ("derived.by.linkki".equals(staticValue)) {
                return this.getDerivedByLinkkiValue(aspect);
            }
            if ("required".equals(aspect.getName())) {
                return this.getRequiredValue(aspect);
            }
            if ("visible".equals(aspect.getName()) || "enabled".equals(aspect.getName())) {
                return this.getVisibleOrEnabledValue(aspect);
            }
            if ("availableValues".equals(aspect.getName()) && aspect.isValuePresent()) {
                return this.getAvailableValuesValue(aspect);
            }
        }
        return (T)super.pull(aspect);
    }

    private <T> T getDerivedByLinkkiValue(Aspect<T> aspect) {
        return (T)this.findModelElement().map(this::getLabel).orElseGet(() -> (String)super.pull(aspect));
    }

    private <T> T getAvailableValuesValue(Aspect<T> aspect) {
        return (T)this.findModelElement().map(this::getValueSet).filter(ValueSet::isDiscrete).map(vs -> vs.getValues(false)).orElseGet(() -> super.pull(aspect));
    }

    private String getLabel(ModelElement modelElement) {
        return modelElement.getLabel(UiFramework.getLocale());
    }

    private <T> T getRequiredValue(Aspect<T> aspect) {
        return (T)this.getRequiredTyped(aspect);
    }

    private <T> T getVisibleOrEnabledValue(Aspect<T> aspect) {
        return (T)this.getVisibleOrEnabledTyped(aspect);
    }

    private Boolean getRequiredTyped(Aspect<Boolean> aspect) {
        boolean otherDispatcherRequired = Optional.ofNullable((Boolean)super.pull(aspect)).orElse(false);
        return otherDispatcherRequired || this.isRequiredInModel();
    }

    private Boolean getVisibleOrEnabledTyped(Aspect<Boolean> aspect) {
        boolean otherDispatcherValue = Optional.ofNullable((Boolean)super.pull(aspect)).orElse(true);
        return otherDispatcherValue ? this.isVisibleOrEnabledInModel() : otherDispatcherValue;
    }

    private boolean isVisibleOrEnabledInModel() {
        return this.findModelElement().map(this::getValueSet).map(ValueSet::isEmpty).orElse(false) == false;
    }

    private boolean isRequiredInModel() {
        return this.findModelElement().map(this::getValueSet).map(this::isNotRequired).orElse(true) == false;
    }

    private boolean isNotRequired(ValueSet<?> valueSet) {
        return valueSet.isEmpty() || valueSet.containsNull();
    }

    private ValueSet<?> getValueSet(ModelElement modelElement) {
        Object modelObject;
        if (modelElement instanceof PolicyAttribute && (modelObject = this.modelObjectSupplier.get()) instanceof IModelObject) {
            PolicyAttribute policyAttribute = (PolicyAttribute)modelElement;
            return policyAttribute.getValueSet((IModelObject)modelObject);
        }
        return new UnrestrictedValueSet();
    }

    private Optional<ModelElement> findModelElement() {
        Class<?> modelObjectClass;
        Object modelObject = this.modelObjectSupplier.get();
        Class<?> clazz = modelObjectClass = modelObject != null ? modelObject.getClass() : this.modelObjectClassSupplier.get();
        if (modelObjectClass != null) {
            return this.modelElementCache.computeIfAbsent(modelObjectClass, this::findModelElement);
        }
        return Optional.empty();
    }

    private Optional<ModelElement> findModelElement(Class<?> modelObjectClass) {
        if (IpsModel.isPolicyCmptType(modelObjectClass) || IpsModel.isProductCmptType(modelObjectClass)) {
            Type type = IpsModel.getType(modelObjectClass);
            if (this.modelAttribute.isEmpty()) {
                return Optional.of(type);
            }
            if (type.isAttributePresent(this.modelAttribute)) {
                Attribute attribute = type.getAttribute(this.modelAttribute);
                return Optional.of(attribute);
            }
        }
        return Optional.empty();
    }

    public static PropertyDispatcher createIpsPropertyDispatcher(Object pmo, BoundProperty boundProperty, PropertyDispatcher standardDispatchers) {
        if (ModelObjects.isAccessible((Object)pmo, (String)boundProperty.getModelObject())) {
            return new IpsPropertyDispatcher(ModelObjects.supplierFor((Object)pmo, (String)boundProperty.getModelObject()), ModelObjects.classSupplierFor((Object)pmo, (String)boundProperty.getModelObject()), boundProperty.getModelAttribute(), standardDispatchers);
        }
        return standardDispatchers;
    }
}

