/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.converters;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.function.SerializableFunction;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Currency;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.jsoup.internal.StringUtil;
import org.linkki.ips.decimalfield.FormattedStringToDecimalConverter;

public class StringToMoneyConverter
implements Converter<String, Money> {
    private static final long serialVersionUID = 1L;
    private final FormattedStringToDecimalConverter stringToDecimalConverter = new FormattedStringToDecimalConverter();

    public Result<Money> convertToModel(@CheckForNull String value, ValueContext context) {
        Currency currency;
        if (StringUtil.isBlank((String)value)) {
            return Result.ok((Object)Money.NULL);
        }
        String trimmedValue = value.trim();
        String regex = "(.+)(\\w{3})";
        Matcher matcher = Pattern.compile(regex).matcher(trimmedValue);
        if (!matcher.matches()) {
            return Result.error((String)("Can't convert " + trimmedValue + " to Money. The last 3 characters must be a supported ISO 4217 currency code and the input string must contain at least 1 number."));
        }
        String decimalValue = matcher.group(1);
        String currencyCode = matcher.group(2);
        try {
            currency = Currency.getInstance(currencyCode);
        }
        catch (IllegalArgumentException e) {
            return Result.error((String)("Can't convert " + trimmedValue + " to Money. The last 3 characters must be a supported ISO 4217 currency code."));
        }
        return this.stringToDecimalConverter.convertToModel(decimalValue, context).map((SerializableFunction & Serializable)v -> Money.valueOf((Decimal)v, (Currency)currency));
    }

    @CheckForNull
    public String convertToPresentation(@CheckForNull Money value, ValueContext context) {
        if (Money.NULL.equals((Object)value) || value == null) {
            return null;
        }
        String decimalString = this.stringToDecimalConverter.convertToPresentation(value.getAmount(), context);
        String currencyString = value.getCurrency().getCurrencyCode();
        return String.format("%s %s", decimalString, currencyString);
    }
}

