/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.decimalfield;

import com.vaadin.flow.data.binder.Result;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigDecimal;
import org.linkki.core.ui.converters.FormattedStringToNumberConverter;

public class FormattedStringToBigDecimalConverter
extends FormattedStringToNumberConverter<BigDecimal> {
    public static final String DEFAULT_FORMAT = "#,##0.00##";
    private static final long serialVersionUID = 1L;

    public FormattedStringToBigDecimalConverter() {
        this(DEFAULT_FORMAT);
    }

    public FormattedStringToBigDecimalConverter(String format) {
        super(format);
    }

    @CheckForNull
    protected BigDecimal getNullValue() {
        return null;
    }

    protected Result<BigDecimal> convertToModel(@NonNull Number value) {
        Result result;
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            result = Result.ok((Object)bigDecimal);
        } else {
            result = Result.ok((Object)new BigDecimal(value.toString()));
        }
        return result;
    }
}

