/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.ips.decimalfield;

import com.vaadin.flow.data.converter.Converter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.property.BoundProperty;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.defaults.ui.aspects.EnabledAspectDefinition;
import org.linkki.core.defaults.ui.aspects.VisibleAspectDefinition;
import org.linkki.core.defaults.ui.aspects.types.EnabledType;
import org.linkki.core.defaults.ui.aspects.types.RequiredType;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.DerivedReadOnlyAspectDefinition;
import org.linkki.core.ui.aspects.LabelAspectDefinition;
import org.linkki.core.ui.aspects.RequiredAspectDefinition;
import org.linkki.core.ui.aspects.ValueAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.LinkkiPositioned;
import org.linkki.core.vaadin.component.ComponentFactory;
import org.linkki.ips.decimalfield.FormattedStringToDecimalConverter;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@LinkkiBoundProperty(value=DecimalFieldBoundPropertyCreator.class)
@LinkkiComponent(value=DecimalFieldComponentDefinitionCreator.class)
@LinkkiAspect(value=DecimalFieldAspectCreator.class)
@LinkkiPositioned
public @interface UIDecimalField {
    @LinkkiPositioned.Position
    public int position();

    public String label() default "derived.by.linkki";

    public EnabledType enabled() default EnabledType.ENABLED;

    public RequiredType required() default RequiredType.NOT_REQUIRED;

    public VisibleType visible() default VisibleType.VISIBLE;

    public int maxLength() default 0;

    public String width() default "";

    public String format() default "#,##0.00##";

    public String modelObject() default "modelObject";

    public String modelAttribute() default "";

    public static class DecimalFieldComponentDefinitionCreator
    implements ComponentDefinitionCreator<UIDecimalField> {
        public LinkkiComponentDefinition create(UIDecimalField annotation, AnnotatedElement annotatedElement) {
            return pmo -> ComponentFactory.newNumberField((int)annotation.maxLength(), (String)annotation.width(), (String)"[-+,\\.\\d]");
        }
    }

    public static class DecimalFieldBoundPropertyCreator
    implements BoundPropertyCreator<UIDecimalField> {
        public BoundProperty createBoundProperty(UIDecimalField annotation, AnnotatedElement annotatedElement) {
            return BoundProperty.of((Method)((Method)annotatedElement)).withModelAttribute(annotation.modelAttribute()).withModelObject(annotation.modelObject());
        }
    }

    public static class DecimalFieldAspectCreator
    implements AspectDefinitionCreator<UIDecimalField> {
        public LinkkiAspectDefinition create(UIDecimalField annotation) {
            EnabledAspectDefinition enabledAspectDefinition = new EnabledAspectDefinition(annotation.enabled());
            RequiredAspectDefinition requiredAspectDefinition = new RequiredAspectDefinition(annotation.required(), enabledAspectDefinition);
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new LabelAspectDefinition(annotation.label()), enabledAspectDefinition, requiredAspectDefinition, new VisibleAspectDefinition(annotation.visible()), new ValueAspectDefinition((Converter)new FormattedStringToDecimalConverter(annotation.format())), new DerivedReadOnlyAspectDefinition()});
        }
    }
}

