/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search.annotation;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.linkki.core.binding.descriptor.aspect.Aspect;
import org.linkki.core.binding.descriptor.aspect.LinkkiAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.annotation.AspectDefinitionCreator;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.descriptor.aspect.base.CompositeAspectDefinition;
import org.linkki.core.binding.descriptor.aspect.base.ModelToUiAspectDefinition;
import org.linkki.core.binding.descriptor.property.annotation.BoundPropertyCreator;
import org.linkki.core.binding.descriptor.property.annotation.LinkkiBoundProperty;
import org.linkki.core.binding.dispatcher.PropertyDispatcher;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.binding.uicreation.LinkkiComponentDefinition;
import org.linkki.core.binding.wrapper.ComponentWrapper;
import org.linkki.core.binding.wrapper.WrapperType;
import org.linkki.core.defaults.columnbased.pmo.TableFooterPmo;
import org.linkki.core.ui.creation.table.GridComponentDefinition;
import org.linkki.core.ui.creation.table.GridLayoutDefinition;
import org.linkki.core.ui.table.aspects.GridSelectionAspectDefinition;
import org.linkki.core.uicreation.ComponentDefinitionCreator;
import org.linkki.core.uicreation.layout.LayoutDefinitionCreator;
import org.linkki.core.uicreation.layout.LinkkiLayout;
import org.linkki.core.uicreation.layout.LinkkiLayoutDefinition;
import org.linkki.util.handler.Handler;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@LinkkiComponent(value=GridComponentDefinitionCreator.class)
@LinkkiLayout(value=GridLayoutDefinitionCreator.class)
@LinkkiBoundProperty(value=BoundPropertyCreator.EmptyPropertyCreator.class)
@LinkkiAspect(value=TableAspectDefinitionCreator.class)
public @interface UISearchTable {
    public GridVariant[] variants() default {GridVariant.LUMO_WRAP_CELL_CONTENT, GridVariant.LUMO_COMPACT, GridVariant.LUMO_NO_BORDER};

    public static class TablePageLengthAspectDefinition
    extends ModelToUiAspectDefinition<Integer> {
        public static final String NAME = "pageLength";

        public Aspect<Integer> createAspect() {
            return Aspect.of((String)NAME);
        }

        public Consumer<Integer> createComponentValueSetter(ComponentWrapper componentWrapper) {
            return pageLength -> {
                Grid table = (Grid)componentWrapper.getComponent();
                if (pageLength < 1 && !table.isAllRowsVisible()) {
                    table.setAllRowsVisible(true);
                } else if (pageLength >= 1) {
                    if (table.isAllRowsVisible()) {
                        table.setAllRowsVisible(false);
                    }
                    if (table.getPageSize() != pageLength.intValue()) {
                        table.setPageSize(pageLength.intValue());
                    }
                    int headerAndFooter = 1 + table.getFooterRows().size();
                    table.setHeight((pageLength + headerAndFooter) * 3 + "em");
                }
            };
        }
    }

    public static class TableItemsAspectDefinition
    implements LinkkiAspectDefinition {
        public static final String NAME = "items";

        public Handler createUiUpdater(PropertyDispatcher propertyDispatcher, ComponentWrapper componentWrapper) {
            ((Grid)componentWrapper.getComponent()).setItems(new ListDataProvider(new ArrayList()));
            return () -> {
                ListDataProvider listDataProvider;
                Collection backendList;
                Collection newItems = (Collection)propertyDispatcher.pull(Aspect.of((String)NAME));
                if (!Objects.equals(newItems, backendList = (listDataProvider = (ListDataProvider)((Grid)componentWrapper.getComponent()).getDataProvider()).getItems())) {
                    backendList.clear();
                    backendList.addAll(newItems);
                    listDataProvider.refreshAll();
                }
            };
        }
    }

    public static class TableFooterAspectDefinition
    extends ModelToUiAspectDefinition<Optional<TableFooterPmo>> {
        public static final String NAME = "footerPmo";

        public Aspect<Optional<TableFooterPmo>> createAspect() {
            return Aspect.of((String)NAME);
        }

        public Consumer<Optional<TableFooterPmo>> createComponentValueSetter(ComponentWrapper componentWrapper) {
            return footerPmo -> {
                Grid grid = (Grid)componentWrapper.getComponent();
                if (footerPmo.isPresent()) {
                    for (Grid.Column column : grid.getColumns()) {
                        column.setFooter(((TableFooterPmo)footerPmo.get()).getFooterText(column.getKey()));
                    }
                }
            };
        }
    }

    public static class TableAspectDefinitionCreator
    implements AspectDefinitionCreator<UISearchTable> {
        public LinkkiAspectDefinition create(UISearchTable annotation) {
            return new CompositeAspectDefinition(new LinkkiAspectDefinition[]{new TablePageLengthAspectDefinition(), new TableItemsAspectDefinition(), new TableFooterAspectDefinition(), new GridSelectionAspectDefinition(this){

                public boolean supports(WrapperType type) {
                    return true;
                }
            }});
        }
    }

    public static class GridLayoutDefinitionCreator
    implements LayoutDefinitionCreator<UISearchTable> {
        public LinkkiLayoutDefinition create(UISearchTable annotation, AnnotatedElement annotatedElement) {
            return new GridLayoutDefinition();
        }
    }

    public static class GridComponentDefinitionCreator
    implements ComponentDefinitionCreator<UISearchTable> {
        public LinkkiComponentDefinition create(UISearchTable annotation, AnnotatedElement annotatedElement) {
            return new GridComponentDefinition(annotation.variants());
        }
    }
}

