/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search.pmo;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.defaults.ui.aspects.types.VisibleType;
import org.linkki.core.ui.aspects.annotation.BindVisible;
import org.linkki.core.ui.element.annotation.UILabel;
import org.linkki.core.ui.nested.annotation.UINestedComponent;
import org.linkki.search.pmo.SearchResultTablePmo;
import org.linkki.search.util.NlsSearch;

public class SearchResultPmo<MODEL_OBJECT, ROW> {
    private static final String RESULT_COUNT_TEMPLATE_PLURAL = "SearchResultPmo.resultCount";
    private static final String RESULT_COUNT_LIMITED_TEMPLATE_PLURAL = "SearchResultPmo.resultCountLimited";
    private static final String RESULT_COUNT_TEMPLATE_SINGULAR = "SearchResultPmo.oneResult";
    private static final String INITIAL_SEARCH_HINT_TEMPLATE = "SearchResultPmo.initialSearchHint";
    private static final String EMPTY_SEARCH_RESULT_HINT_TEMPLATE = "SearchResultPmo.emptySearchResultHint";
    private final SearchResultTablePmo<MODEL_OBJECT, ROW> searchResultTablePmo;
    private final Optional<Integer> maxResult;
    private final Supplier<MessageList> messages;
    private final Supplier<List<? extends MODEL_OBJECT>> modelSupplier;

    public SearchResultPmo(SearchResultTablePmo<MODEL_OBJECT, ROW> searchResultTablePmo, Supplier<List<? extends MODEL_OBJECT>> modelSupplier, Supplier<MessageList> messages, Optional<Integer> maxResult) {
        this.searchResultTablePmo = searchResultTablePmo;
        this.modelSupplier = modelSupplier;
        this.messages = messages;
        this.maxResult = maxResult;
    }

    @BindVisible
    @UILabel(position=10)
    public String getInitialSearchHint() {
        return NlsSearch.getString(INITIAL_SEARCH_HINT_TEMPLATE);
    }

    public boolean isInitialSearchHintVisible() {
        return this.messages.get().isEmpty() && this.getResultCount() <= 0;
    }

    @UILabel(position=20, visible=VisibleType.DYNAMIC)
    public String getEmptySearchResultHint() {
        return NlsSearch.getString(EMPTY_SEARCH_RESULT_HINT_TEMPLATE);
    }

    public boolean isEmptySearchResultHintVisible() {
        return this.getResultCount() <= 0 && this.isMostSevereMessageVisible();
    }

    @BindVisible
    @UILabel(position=40)
    public String getMostSevereMessage() {
        return this.messages.get().getMessageWithHighestSeverity().map(Message::getText).orElse("");
    }

    public boolean isMostSevereMessageVisible() {
        return this.messages.get().getMessageWithHighestSeverity().isPresent();
    }

    @UILabel(position=60, visible=VisibleType.DYNAMIC)
    public String getSearchResultCount() {
        int count = this.getResultCount();
        if (count <= 0) {
            return "";
        }
        if (count == 1) {
            return NlsSearch.getString(RESULT_COUNT_TEMPLATE_SINGULAR);
        }
        if (this.maxResult.isPresent() && count > this.maxResult.get()) {
            return NlsSearch.format(RESULT_COUNT_LIMITED_TEMPLATE_PLURAL, Integer.toString(this.maxResult.get()));
        }
        return NlsSearch.format(RESULT_COUNT_TEMPLATE_PLURAL, Integer.toString(count));
    }

    public boolean isSearchResultCountVisible() {
        return this.isResultPresent();
    }

    @BindVisible
    @UINestedComponent(position=50)
    public SearchResultTablePmo<MODEL_OBJECT, ROW> getSearchResultTable() {
        return this.searchResultTablePmo;
    }

    public boolean isSearchResultTableVisible() {
        return this.isResultPresent();
    }

    private int getResultCount() {
        return this.modelSupplier.get().size();
    }

    private boolean isResultPresent() {
        return this.getResultCount() > 0;
    }

    public Optional<ROW> getSelectedRow() {
        if (this.isResultPresent()) {
            return Optional.ofNullable(this.getSearchResultTable().getSelection());
        }
        return Optional.empty();
    }
}

