/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.search.pmo;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.linkki.core.defaults.columnbased.pmo.SimpleTablePmo;
import org.linkki.core.ui.table.pmo.SelectableTablePmo;
import org.linkki.search.annotation.UISearchTable;

@UISearchTable
public class SearchResultTablePmo<T, ROW>
extends SimpleTablePmo<T, ROW>
implements SelectableTablePmo<ROW> {
    private final Function<T, ROW> rowCreator;
    private final Consumer<ROW> primaryAction;
    private final Class<? extends ROW> rowClass;
    @CheckForNull
    private ROW selectedRow;
    private final Optional<Integer> pageSize;

    public SearchResultTablePmo(Supplier<List<? extends T>> modelObjectSupplier, Function<T, ROW> rowCreator, Class<? extends ROW> rowClass, Consumer<ROW> primaryAction, Optional<Integer> pageSize) {
        super(modelObjectSupplier);
        this.rowCreator = rowCreator;
        this.primaryAction = primaryAction;
        this.rowClass = rowClass;
        this.pageSize = pageSize;
    }

    protected ROW createRow(T modelObject) {
        return this.rowCreator.apply(modelObject);
    }

    public Class<? extends ROW> getItemPmoClass() {
        return this.rowClass;
    }

    public int getPageLength() {
        return this.pageSize.orElse(0);
    }

    public ROW getSelection() {
        List items = this.getItems();
        if (!items.contains(this.selectedRow) && !items.isEmpty()) {
            this.setSelection(this.getItems().get(0));
        }
        return this.selectedRow;
    }

    public void onDoubleClick() {
        if (this.selectedRow != null) {
            this.primaryAction.accept(this.selectedRow);
        }
    }

    public void setSelection(@CheckForNull ROW selectedRow) {
        if (selectedRow != null) {
            this.selectedRow = selectedRow;
        }
    }
}

