/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Objects;
import java.util.function.Supplier;

public class LazyReference<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    @CheckForNull
    private T reference;

    public LazyReference(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Deprecated(since="2.2.0")
    public T getReference() {
        if (this.reference == null) {
            this.reference = this.supplier.get();
        }
        return Objects.requireNonNull(this.reference);
    }

    @Override
    public T get() {
        return this.getReference();
    }

    public boolean isValuePresent() {
        return this.reference != null;
    }

    public static <T> LazyReference<T> lazy(Supplier<T> supplier) {
        return new LazyReference<T>(supplier);
    }
}

