/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.linkki.util.reflection.accessor.ReadMethod;

public class MemberAccessors {
    private static final Map<Member, Function<Object, Object>> ACCESSOR_CACHE = new ConcurrentHashMap<Member, Function<Object, Object>>();

    private MemberAccessors() {
    }

    public static <T> T getValue(Object object, Member fieldOrMethod) {
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            return (T)MemberAccessors.getFieldValue(object, field);
        }
        if (fieldOrMethod instanceof Method) {
            Method method = (Method)fieldOrMethod;
            Function accessor = ACCESSOR_CACHE.computeIfAbsent(fieldOrMethod, key -> MemberAccessors.getMethodAsFunction(method));
            try {
                return (T)accessor.apply(object);
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e.getCause());
            }
        }
        throw new IllegalArgumentException("Only field or method is supported, found " + fieldOrMethod.getClass().getCanonicalName() + " as type of " + MemberAccessors.getNameOf(fieldOrMethod));
    }

    private static Function<Object, Object> getMethodAsFunction(Method method) {
        if (Void.TYPE.equals(method.getReturnType())) {
            throw new IllegalArgumentException(String.format("Cannot call method %s#%s: void as return type is not allowed", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        return (Function)new ReadMethod(method).getMethodAsFunction();
    }

    private static Object getFieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access field " + field, e);
        }
    }

    private static String getNameOf(Member member) {
        return member.getDeclaringClass().getName() + "#" + member.getName();
    }

    @Deprecated(since="2.5.0")
    public static Class<?> getType(Member fieldOrMethod) {
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            return field.getType();
        }
        if (fieldOrMethod instanceof Method) {
            Method method = (Method)fieldOrMethod;
            return method.getReturnType();
        }
        throw new IllegalArgumentException("Only field or method is supported, found " + fieldOrMethod.getClass().getCanonicalName() + " as type of " + MemberAccessors.getNameOf(fieldOrMethod));
    }

    public static Class<?> getType(Member fieldOrMethod, Type clazz) {
        Type type;
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            type = field.getGenericType();
        } else if (fieldOrMethod instanceof Method) {
            Method method = (Method)fieldOrMethod;
            type = method.getGenericReturnType();
        } else {
            throw MemberAccessors.exceptionUnableToDetermineTypeOf(fieldOrMethod, "Only field or method is supported, but found " + fieldOrMethod.getClass().getCanonicalName() + " as accessor type of the member.");
        }
        Class rawType = TypeUtils.getRawType((Type)type, (Type)clazz);
        if (rawType != null) {
            return rawType;
        }
        if (type instanceof TypeVariable) {
            Class boundClass;
            TypeVariable typeVariable = (TypeVariable)type;
            Object[] implicitBounds = TypeUtils.getImplicitBounds((TypeVariable)typeVariable);
            if (implicitBounds.length > 1) {
                throw MemberAccessors.exceptionUnableToDetermineTypeOf(fieldOrMethod, "The type variable has multiple bounds:" + Arrays.toString(implicitBounds));
            }
            Object object = implicitBounds[0];
            if (object instanceof Class && !Object.class.equals((Object)(boundClass = (Class)object))) {
                return boundClass;
            }
            throw MemberAccessors.exceptionUnableToDetermineTypeOf(fieldOrMethod, "Cannot determine the bound of the type variable.");
        }
        throw new IllegalArgumentException("Unable to determine the type of the member " + MemberAccessors.getNameOf(fieldOrMethod));
    }

    private static IllegalArgumentException exceptionUnableToDetermineTypeOf(Member fieldOrMethod, String cause) {
        return new IllegalArgumentException("Unable to determine the type of the member " + MemberAccessors.getNameOf(fieldOrMethod) + ". " + cause);
    }
}

