/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.linkki.util.LazyReference;
import org.linkki.util.reflection.accessor.InvokeMethod;
import org.linkki.util.reflection.accessor.ReadMethod;
import org.linkki.util.reflection.accessor.WriteMethod;

class PropertyAccessDescriptor<T, V> {
    private final Class<? extends T> boundClass;
    private final String propertyName;
    private final Supplier<Optional<Method>> getter = LazyReference.lazy(this::findGetter);
    private final Supplier<Optional<Method>> setter = LazyReference.lazy(this::findSetter);
    private final Supplier<Optional<Method>> invoker = LazyReference.lazy(this::findInvoker);
    private final String capitalizedPropertyName;

    PropertyAccessDescriptor(Class<? extends T> boundClass, String propertyName) {
        this.boundClass = Objects.requireNonNull(boundClass, "clazz must not be null");
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName must not be null");
        this.capitalizedPropertyName = StringUtils.capitalize((String)propertyName);
    }

    private Optional<Method> findGetter() {
        Method foundMethod = MethodUtils.getMatchingAccessibleMethod(this.boundClass, (String)("get" + this.capitalizedPropertyName), (Class[])new Class[0]);
        if (foundMethod == null) {
            foundMethod = MethodUtils.getMatchingAccessibleMethod(this.boundClass, (String)("is" + this.capitalizedPropertyName), (Class[])new Class[0]);
        }
        if (foundMethod != null && Void.TYPE.equals(foundMethod.getReturnType())) {
            return Optional.empty();
        }
        return Optional.ofNullable(foundMethod);
    }

    /*
     * Exception decompiling
     */
    private Optional<Method> findSetter() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<Method> findInvoker() {
        return Optional.ofNullable(MethodUtils.getAccessibleMethod(this.boundClass, (String)this.propertyName, (Class[])new Class[0]));
    }

    public WriteMethod<T, V> createWriteMethod() {
        return new WriteMethod(this.getBoundClass(), this.getPropertyName(), this.getReflectionWriteMethod());
    }

    public ReadMethod<T, V> createReadMethod() {
        return new ReadMethod(this.getBoundClass(), this.getPropertyName(), this.getReflectionReadMethod());
    }

    public InvokeMethod<T> createInvokeMethod() {
        return new InvokeMethod<T>(this.getBoundClass(), this.getPropertyName(), this.getReflectionInvokeMethod());
    }

    Supplier<Optional<Method>> getReflectionWriteMethod() {
        return this.setter;
    }

    Supplier<Optional<Method>> getReflectionReadMethod() {
        return this.getter;
    }

    Supplier<Optional<Method>> getReflectionInvokeMethod() {
        return this.invoker;
    }

    public Class<? extends T> getBoundClass() {
        return this.boundClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return PropertyAccessDescriptor.class.getSimpleName() + "[" + this.boundClass + "#" + this.propertyName + "]";
    }

    private /* synthetic */ Method lambda$findSetter$1(Class[] params) {
        return MethodUtils.getMatchingAccessibleMethod(this.boundClass, (String)("set" + this.capitalizedPropertyName), (Class[])params);
    }
}

