/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.linkki.util.LazyInitializingMap;
import org.linkki.util.reflection.accessor.InvokeMethod;
import org.linkki.util.reflection.accessor.PropertyAccessDescriptor;
import org.linkki.util.reflection.accessor.ReadMethod;
import org.linkki.util.reflection.accessor.WriteMethod;

public final class PropertyAccessor<T, V> {
    private static final LazyInitializingMap<CacheKey, PropertyAccessor<?, ?>> ACCESSOR_CACHE = new LazyInitializingMap<CacheKey, PropertyAccessor>(key -> new PropertyAccessor(key.clazz, key.property));
    private final String propertyName;
    private final ReadMethod<T, V> readMethod;
    private final WriteMethod<T, V> writeMethod;
    private final InvokeMethod<T> invokeMethod;

    PropertyAccessor(Class<? extends T> boundClass, String propertyName) {
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName must not be null");
        Objects.requireNonNull(boundClass, "boundClass must not be null");
        PropertyAccessDescriptor propertyAccessDescriptor = new PropertyAccessDescriptor(boundClass, propertyName);
        this.readMethod = propertyAccessDescriptor.createReadMethod();
        this.writeMethod = propertyAccessDescriptor.createWriteMethod();
        this.invokeMethod = propertyAccessDescriptor.createInvokeMethod();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public V getPropertyValue(T boundObject) {
        return this.readMethod.readValue(boundObject);
    }

    public void setPropertyValue(T boundObject, @CheckForNull V value) {
        this.writeMethod.writeValue(boundObject, value);
    }

    public void invoke(T boundObject) {
        this.invokeMethod.invoke(boundObject);
    }

    public boolean canWrite() {
        return this.writeMethod.isPresent();
    }

    public boolean canInvoke() {
        return this.invokeMethod.isPresent();
    }

    public boolean canRead() {
        return this.readMethod.isPresent();
    }

    public Class<?> getValueClass() {
        return this.readMethod.getReturnType();
    }

    public static <T> PropertyAccessor<T, ?> get(Class<T> clazz, String property) {
        return ACCESSOR_CACHE.get(new CacheKey(clazz, property));
    }

    private record CacheKey(Class<?> clazz, String property) {
        private CacheKey(@NonNull Class<?> clazz, String property) {
            this.clazz = Objects.requireNonNull(clazz, "clazz must not be null");
            this.property = Objects.requireNonNull(property, "property must not be null");
        }
    }
}

