/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.linkki.util.BeanUtils;
import org.linkki.util.reflection.accessor.AbstractMethod;

final class ReadMethod<T, V>
extends AbstractMethod<T, Function<T, V>> {
    ReadMethod(Class<? extends T> boundClass, String propertyName, Supplier<Optional<Method>> methodSupplier) {
        super(boundClass, propertyName, methodSupplier);
    }

    public ReadMethod(Method method) {
        super(method.getDeclaringClass(), BeanUtils.getPropertyName(method), () -> Optional.of(method));
    }

    public V readValue(T boundObject) {
        return (V)((Function)this.getMethodAsFunction()).apply(boundObject);
    }

    @Override
    protected Function<T, V> fallbackReflectionCall(Method method) {
        return o -> {
            try {
                return method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw this.errorCallingMethod(e).get();
            }
        };
    }

    @Override
    protected Function<T, V> handleExceptionForMethodHandle(Function<T, V> methodAsFunction) {
        return o -> {
            try {
                return methodAsFunction.apply(o);
            }
            catch (RuntimeException e) {
                throw this.errorCallingMethod(e).get();
            }
        };
    }

    public Class<V> getReturnType() {
        return this.getMethodWithExceptionHandling().getReturnType();
    }

    @Override
    protected CallSite getCallSiteForFunction(MethodHandles.Lookup lookup, MethodHandle methodHandle) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), methodHandle, methodHandle.type());
    }

    public String toString() {
        return "read method for " + this.getBoundClass().getName() + "#" + this.getPropertyName();
    }
}

