/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.ui.test;

import com.github.mvysny.kaributesting.v10.MockVaadin;
import com.github.mvysny.kaributesting.v10.Routes;
import com.github.mvysny.kaributesting.v10.mock.MockVaadinServlet;
import com.github.mvysny.kaributesting.v10.mock.MockedUI;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinSession;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.linkki.core.ui.test.CustomInstantiatorMockServlet;
import org.linkki.core.ui.test.WithLocale;

public class KaribuUIExtension
implements BeforeEachCallback,
AfterEachCallback {
    public static final String PROPERTY_PRODUCTION_MODE = "vaadin.productionMode";

    protected UI setUpUI() {
        return this.setUpUI(MockedUI::new, (VaadinServlet)new MockVaadinServlet());
    }

    protected UI setUpUI(Supplier<UI> uiFactory, VaadinServlet servlet) {
        MockVaadin.setup(uiFactory::get, (VaadinServlet)servlet);
        UI ui = UI.getCurrent();
        ui.setLocale(Locale.ROOT);
        return ui;
    }

    public static KaribuUIExtension withConfiguration(Consumer<KaribuConfiguration> configurator) {
        KaribuConfiguration configuration = KaribuConfiguration.withDefaults();
        configurator.accept(configuration);
        return KaribuUIExtension.withConfiguration(configuration);
    }

    public static KaribuUIExtension withConfiguration(final KaribuConfiguration configuration) {
        return new KaribuUIExtension(){

            @Override
            public UI setUpUI() {
                if (configuration.productionMode) {
                    System.setProperty(KaribuUIExtension.PROPERTY_PRODUCTION_MODE, "true");
                }
                Routes routes = new Routes(configuration.routes, configuration.errorRoutes, true);
                UI ui = this.setUpUI(MockedUI::new, (VaadinServlet)new CustomInstantiatorMockServlet(routes, configuration.instances));
                ui.setLocale(configuration.locale);
                return ui;
            }
        };
    }

    public void afterEach(ExtensionContext context) {
        MockVaadin.tearDown();
        UI.setCurrent(null);
        VaadinSession.setCurrent(null);
        System.clearProperty(PROPERTY_PRODUCTION_MODE);
    }

    public void beforeEach(ExtensionContext context) {
        UI ui = this.setUpUI();
        this.getAnnotatedLocale(context).ifPresent(arg_0 -> ((UI)ui).setLocale(arg_0));
    }

    private Optional<Locale> getAnnotatedLocale(ExtensionContext context) {
        return context.getParent().map(ExtensionContext::getElement).flatMap(annotatedElement -> AnnotationUtils.findAnnotation((Optional)annotatedElement, WithLocale.class)).map(WithLocale::value).map(Locale::forLanguageTag);
    }

    public static class KaribuConfiguration {
        private final Set<Class<? extends Component>> routes = new HashSet<Class<? extends Component>>();
        private final Set<Class<? extends HasErrorParameter<?>>> errorRoutes = new HashSet();
        private final Map<ClassKey, Supplier<?>> instances = new HashMap();
        private boolean productionMode = false;
        private Locale locale = Locale.ROOT;

        public KaribuConfiguration() {
            this.instances.put(new ClassKey(I18NProvider.class), () -> new DefaultI18NProvider(List.of(Locale.ENGLISH, Locale.GERMAN)));
        }

        public static KaribuConfiguration withDefaults() {
            return new KaribuConfiguration();
        }

        @SafeVarargs
        public final KaribuConfiguration addRoutes(Class<? extends Component> ... routes) {
            this.routes.addAll(Set.of(routes));
            return this;
        }

        @SafeVarargs
        public final KaribuConfiguration addErrorRoutes(Class<? extends HasErrorParameter<?>> ... errorRoutes) {
            this.errorRoutes.addAll(Set.of(errorRoutes));
            return this;
        }

        public KaribuConfiguration addRoute(Class<? extends Component> route, Supplier<? extends Component> supplier) {
            this.routes.add(route);
            this.instances.put(new ClassKey(route), supplier);
            return this;
        }

        public <T> KaribuConfiguration addInstance(Class<T> type, Supplier<? extends T> value) {
            this.instances.put(new ClassKey(type), value);
            return this;
        }

        public KaribuConfiguration setI18NProvider(I18NProvider provider) {
            return this.addInstance(I18NProvider.class, () -> provider);
        }

        public KaribuConfiguration setProductionMode(boolean productionMode) {
            this.productionMode = productionMode;
            return this;
        }

        public KaribuConfiguration setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public record ClassKey(Class<?> clazz) implements Comparable<ClassKey>
        {
            @Override
            public int compareTo(@NotNull ClassKey o) {
                return Comparator.comparing(key -> key.clazz.getCanonicalName()).compare(this, o);
            }
        }
    }
}

