/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.processor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.ElementUtils;
import org.linkki.tooling.apt.util.ModelBuilder;
import org.linkki.tooling.apt.validator.AspectMethodValidator;
import org.linkki.tooling.apt.validator.BoundPropertyValidator;
import org.linkki.tooling.apt.validator.DynamicFieldValidator;
import org.linkki.tooling.apt.validator.ModelBindingValidator;
import org.linkki.tooling.apt.validator.ModelObjectValidator;
import org.linkki.tooling.apt.validator.PositionValidator;
import org.linkki.tooling.apt.validator.PublicModifierValidator;
import org.linkki.tooling.apt.validator.UITableColumnValidator;
import org.linkki.tooling.apt.validator.Validator;

@SupportedAnnotationTypes(value={"*"})
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Processor needs a zero args constructor, fields are set in init")
public class LinkkiAnnotationProcessor
extends AbstractProcessor {
    public static final String LINKKI_OPTION_PREFIX = "linkki.apt";
    private static final Set<ElementKind> SUPPORTED_ELEMENT_KINDS = new HashSet<ElementKind>(Arrays.asList(ElementKind.CLASS, ElementKind.INTERFACE));
    private Types types;
    private Elements elements;
    private ElementUtils elementUtils;
    private ModelBuilder modelBuilder;
    private List<Validator> validators;
    private ClassLoader classLoader;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedOptions() {
        Stream<String> classpathOption = Stream.of("classpath");
        Stream<String> validatorOptions = this.validators.stream().map((Function<Validator, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/linkki/tooling/apt/validator/Validator;)Ljava/lang/Class;)()).map(Validator::getMessageCodes).flatMap(Collection::stream).map(LinkkiAnnotationProcessor::toLinkkiAptOption);
        return Stream.concat(classpathOption, validatorOptions).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Map<String, String> options = processingEnvironment.getOptions();
        this.classLoader = this.getClassLoader(options);
        this.types = processingEnvironment.getTypeUtils();
        this.elements = processingEnvironment.getElementUtils();
        this.elementUtils = new ElementUtils(this.types, this.elements, this.classLoader);
        this.modelBuilder = new ModelBuilder(this.elementUtils);
        this.validators = Arrays.asList(new PublicModifierValidator(options, this.elementUtils), new ModelObjectValidator(options), new PositionValidator(options), new AspectMethodValidator(options, this.elementUtils), new ModelBindingValidator(options), new DynamicFieldValidator(options, this.elementUtils), new BoundPropertyValidator(options, this.types), new UITableColumnValidator(processingEnvironment));
    }

    private ClassLoader getClassLoader(Map<String, String> options) {
        String option = options.get("classpath");
        if (option == null) {
            return this.getClass().getClassLoader();
        }
        URL[] urls = Stream.of(option.split(";", -1)).filter(it -> !it.isEmpty()).map(t -> {
            try {
                return new File((String)t).toURI().toURL();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).toList().toArray(new URL[0]);
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        try {
            Messager messager = this.processingEnv.getMessager();
            this.elementUtils.getClassElements(annotations, roundEnv).filter(this::isPublic).filter(this::isClassOrInterface).map(this.modelBuilder::convertPmo).forEach(pmo -> {
                try {
                    this.validators.forEach(val -> val.validate((AptPmo)pmo, messager));
                }
                catch (IllegalArgumentException | IllegalStateException | NoSuchElementException t) {
                    String qualifiedName = pmo.getElement().getQualifiedName().toString();
                    this.printExceptionInfo(messager, qualifiedName, t);
                }
            });
        }
        finally {
            if (this.classLoader != this.getClass().getClassLoader() && this.classLoader instanceof URLClassLoader) {
                try {
                    ((URLClassLoader)this.classLoader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private boolean isPublic(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private boolean isClassOrInterface(TypeElement element) {
        return SUPPORTED_ELEMENT_KINDS.contains((Object)element.getKind());
    }

    private void printExceptionInfo(Messager messager, String className, Throwable thrown) {
        String trace = ExceptionUtils.getStackTrace((Throwable)thrown);
        messager.printMessage(Diagnostic.Kind.ERROR, "An exception was thrown while processing the class " + className + ":\n" + trace);
    }

    public static String toLinkkiAptOption(String messageCode) {
        return "linkki.apt." + messageCode;
    }

    public Types getTypes() {
        return this.types;
    }

    public Elements getElements() {
        return this.elements;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }
}

