/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.linkki.core.pmo.ModelObject;

public class ModelObjectProperty {
    private final ModelObject modelObject;
    private final ExecutableElement method;
    private final Set<ExecutableElement> attributes;
    private final TypeElement modelObjectTypeElement;

    public ModelObjectProperty(ExecutableElement method, Set<ExecutableElement> attributes, TypeElement modelObjectTypeElement) {
        if (attributes.isEmpty()) {
            throw new IllegalArgumentException("no attributes found");
        }
        this.modelObject = method.getAnnotation(ModelObject.class);
        this.method = method;
        this.attributes = attributes;
        this.modelObjectTypeElement = modelObjectTypeElement;
    }

    public ModelObject getModelObject() {
        return this.modelObject;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public Set<ExecutableElement> getAttributes() {
        return this.attributes;
    }

    public TypeElement getModelObjectTypeElement() {
        return this.modelObjectTypeElement;
    }

    public String toString() {
        return "ModelObjectProperty [modelObject=" + this.modelObject.name() + ", method=" + String.valueOf(this.method) + ", attributes=" + String.valueOf(this.attributes) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.method, this.modelObject);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelObjectProperty other = (ModelObjectProperty)obj;
        return this.attributes.equals(other.attributes) && this.method.equals(other.method) && this.modelObject.equals((Object)other.modelObject);
    }
}

