/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.pmo.ModelObject;
import org.linkki.tooling.apt.model.AptComponent;
import org.linkki.tooling.apt.model.AptComponentDeclaration;
import org.linkki.tooling.apt.model.AptModelAttribute;
import org.linkki.tooling.apt.model.AptModelObject;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;

@MessageCodes(value={"SETTER_ONLY_IN_MODEL_OBJECT"})
public class BoundPropertyValidator
implements Validator {
    public static final String SETTER_ONLY_IN_MODEL_OBJECT = "SETTER_ONLY_IN_MODEL_OBJECT";
    private final Types types;
    private final Diagnostic.Kind setterOnlyInModelObjectSeverity;

    public BoundPropertyValidator(Map<String, String> options, Types types) {
        this.types = types;
        this.setterOnlyInModelObjectSeverity = Severity.of(options, SETTER_ONLY_IN_MODEL_OBJECT, Diagnostic.Kind.OTHER);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (this.setterOnlyInModelObjectSeverity != Diagnostic.Kind.OTHER) {
            Set<String> propertiesWithSetterInPmo = this.findSettableProperties(pmo.getElement());
            HashMap propertiesWithSetterByModelObject = new HashMap();
            pmo.getComponents().stream().map(AptComponent::getComponentDeclarations).flatMap(Collection::stream).filter(it -> it.getModelObject().isPresent()).filter(it -> !it.isDirectModelBinding()).filter(AptComponentDeclaration::isUsingStandardModelBindingAttributes).forEach(componentDeclaration -> {
                String propertyName = componentDeclaration.getPropertyName();
                if (!propertiesWithSetterInPmo.contains(propertyName)) {
                    String modelAttributeName = componentDeclaration.getModelAttribute().map(AptModelAttribute::getName).orElse(propertyName);
                    componentDeclaration.getModelObject().ifPresent(mo -> {
                        if (propertiesWithSetterByModelObject.computeIfAbsent(mo, m -> this.findSettableProperties(this.types.asElement(m.getType()))).contains(modelAttributeName)) {
                            this.reportMissingSetter(messager, pmo, (AptComponentDeclaration)componentDeclaration, modelAttributeName);
                        }
                    });
                }
            });
        }
    }

    private void reportMissingSetter(Messager messager, AptPmo pmo, AptComponentDeclaration componentDeclaration, String propertyName) {
        if (!SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.setterOnlyInModelObjectSeverity) && !SuppressedWarningsUtils.isSuppressed(componentDeclaration.getElement(), this.setterOnlyInModelObjectSeverity)) {
            String message = Messages.format(SETTER_ONLY_IN_MODEL_OBJECT, componentDeclaration.getAnnotationMirror(), propertyName, componentDeclaration.getModelObject().map(AptModelObject::getAnnotation).map(ModelObject::name).orElse("?"), pmo.getElement());
            messager.printMessage(this.setterOnlyInModelObjectSeverity, message, componentDeclaration.getElement(), componentDeclaration.getAnnotationMirror());
        }
    }

    private Set<String> findSettableProperties(Element modelClass) {
        return modelClass.getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> it.getParameters().size() == 1).map(it -> it.getSimpleName().toString()).filter(it -> it.startsWith("set")).map(it -> StringUtils.uncapitalize((String)it.substring(3))).collect(Collectors.toSet());
    }
}

