/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.lockservice;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.lockservice.StandardLockService;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;

public class LockServiceCassandra
extends StandardLockService {
    private boolean isDatabaseChangeLogLockTableInitialized;
    private ObjectQuotingStrategy quotingStrategy;

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof CassandraDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        try {
            boolean locked;
            this.database.rollback();
            super.init();
            boolean bl = locked = executor.queryForInt((SqlStatement)new RawSqlStatement("SELECT COUNT(*) FROM " + this.database.getDefaultCatalogName() + ".DATABASECHANGELOGLOCK where locked = TRUE ALLOW FILTERING")) > 0;
            if (locked) {
                boolean bl2 = false;
                return bl2;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update((SqlStatement)new LockDatabaseChangeLogStatement());
            if (rowsUpdated == -1 && this.database instanceof MSSQLDatabase) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Database did not return a proper row count (Might have NOCOUNT enabled)");
                this.database.rollback();
                Sql[] sql = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)new LockDatabaseChangeLogStatement(), this.database);
                if (sql.length != 1) {
                    throw new UnexpectedLiquibaseException("Did not expect " + sql.length + " statements");
                }
                rowsUpdated = executor.update((SqlStatement)new RawSqlStatement("EXEC sp_executesql N'SET NOCOUNT OFF " + sql[0].toSql().replace("'", "''") + "'"));
            }
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl3 = false;
                return bl3;
            }
            this.database.commit();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("successfully.acquired.change.log.lock");
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            boolean bl4 = true;
            return bl4;
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public void releaseLock() throws LockException {
        ObjectQuotingStrategy incomingQuotingStrategy = null;
        if (this.quotingStrategy != null) {
            incomingQuotingStrategy = this.database.getObjectQuotingStrategy();
            this.database.setObjectQuotingStrategy(this.quotingStrategy);
        }
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        try {
            if (this.hasDatabaseChangeLogLockTable()) {
                executor.comment("Release Database Lock");
                this.database.rollback();
                executor.update((SqlStatement)new UnlockDatabaseChangeLogStatement());
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException databaseException) {}
            if (incomingQuotingStrategy != null) {
                this.database.setObjectQuotingStrategy(incomingQuotingStrategy);
            }
        }
    }

    public boolean hasDatabaseChangeLogLockTable() {
        return ((CassandraDatabase)this.database).hasDatabaseChangeLogLockTable();
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated) {
        if (!this.isDatabaseChangeLogLockTableInitialized) {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            try {
                this.isDatabaseChangeLogLockTableInitialized = executor.queryForInt((SqlStatement)new RawSqlStatement("SELECT COUNT(*) FROM " + this.database.getDefaultCatalogName() + ".DATABASECHANGELOGLOCK")) > 0;
            }
            catch (LiquibaseException e) {
                if (executor.updatesDatabase()) {
                    throw new UnexpectedLiquibaseException((Throwable)e);
                }
                this.isDatabaseChangeLogLockTableInitialized = !tableJustCreated;
            }
        }
        return this.isDatabaseChangeLogLockTableInitialized;
    }
}

