/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.snapshot;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.ext.cassandra.snapshot.TableSnapshotGeneratorCassandra;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.IndexSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Relation;
import liquibase.util.StringUtil;

public class IndexSnapshotGeneratorCassandra
extends IndexSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof CassandraDatabase) {
            int priority = super.getPriority(objectType, database);
            return priority == 0 ? priority : priority + 5;
        }
        return -1;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(Index.class)) {
            return;
        }
        if (foundObject instanceof Relation) {
            Relation relation = (Relation)foundObject;
            Database database = snapshot.getDatabase();
            String query = String.format("SELECT KEYSPACE_NAME, INDEX_NAME, OPTIONS FROM system_schema.indexes WHERE KEYSPACE_NAME = '%s' AND TABLE_NAME='%s';", database.getDefaultCatalogName(), relation.getName());
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List returnList = executor.queryForList((SqlStatement)new RawSqlStatement(query));
            for (Map tablePropertiesMap : returnList) {
                relation.getIndexes().add(this.readIndex(tablePropertiesMap, relation));
            }
        }
    }

    private Index readIndex(Map<String, ?> tableMap, Relation relation) {
        String indexName = StringUtil.trimToNull((String)((String)tableMap.get("INDEX_NAME")));
        String options = StringUtil.trimToNull((String)((String)tableMap.get("OPTIONS")));
        Index index = new Index();
        index.setName(indexName);
        index.setRelation(relation);
        index.setColumns(this.parseColumns(options));
        return index;
    }

    private List<Column> parseColumns(String options) {
        int startIndex = options.indexOf("target");
        String[] keyValues = options.substring(startIndex, options.indexOf("}", startIndex)).split(":");
        if (keyValues.length == 2) {
            return Collections.singletonList(new Column(keyValues[1]));
        }
        return Collections.emptyList();
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Relation relation = ((Index)example).getRelation();
        Database database = snapshot.getDatabase();
        String query = String.format("SELECT KEYSPACE_NAME, INDEX_NAME, OPTIONS FROM system_schema.indexes WHERE KEYSPACE_NAME = '%s' AND TABLE_NAME='%s' AND INDEX_NAME= '%s';", database.getDefaultCatalogName(), relation.getName(), example.getName());
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List returnList = executor.queryForList((SqlStatement)new RawSqlStatement(query));
        if (returnList.size() != 1) {
            Scope.getCurrentScope().getLog(TableSnapshotGeneratorCassandra.class).warning(String.format("expecting exactly 1 index with name %s, got %s", example.getName(), returnList.size()));
            return null;
        }
        return this.readIndex((Map)returnList.get(0), relation);
    }
}

