/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.RenameColumnGenerator;
import liquibase.statement.core.RenameColumnStatement;
import liquibase.structure.DatabaseObject;

public class RenameColumnGeneratorCassandra
extends RenameColumnGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(RenameColumnStatement statement, Database database) {
        return database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(RenameColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " RENAME " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getOldColumnName()) + " TO " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getNewColumnName()), new DatabaseObject[]{this.getAffectedOldColumn(statement), this.getAffectedNewColumn(statement)})};
    }
}

