/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ChecksShowCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "show"};
    private static final LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>();
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        if (this.isMavenIntegration(commandResultsBuilder)) {
            InMemoryChecksFileAccessor inMemoryChecksFileAccessor = new InMemoryChecksFileAccessor();
            Scope.child(Collections.singletonMap("fileAccessor", inMemoryChecksFileAccessor), () -> this.doRun(commandResultsBuilder));
            return;
        }
        this.doRun(commandResultsBuilder);
    }

    private void doRun(CommandResultsBuilder commandResultsBuilder) {
        String string = (String)commandResultsBuilder.getCommandScope().getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksShowCommandStep.checkFileArgExistence(string, "checks settings", false);
        String string2 = System.lineSeparator() + "Generating report on current configuration of checks using settings in: " + (StringUtil.isEmpty((String)string) ? "liquibase.checks-settings.conf" : string) + System.lineSeparator();
        Scope.getCurrentScope().getUI().sendMessage(string2);
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, true);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("List available checks, their configuration options, and current settings");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    public static void writeTableToOutput(CommandResultsBuilder object, String object2, boolean bl2) {
        List<AbstractLiquibaseRule> list = ChecksShowCommandStep.listAllRules();
        String string = (String)object.getCommandScope().getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        object2 = new CheckSettingsConfigHelper((String)object2, string).read(list);
        List<List<String>> list2 = ChecksShowCommandStep.createTableWithData(list, (CheckSettingsConfig)object2, bl2);
        object = ChecksShowCommandStep.createOutputWriter(object);
        TableOutput.formatOutput(list2, new ArrayList<Integer>(columns.values()), (boolean)true, (Writer)object);
        if (object2 != null) {
            ((CheckSettingsConfig)object2).outputWarningMessage();
        }
    }

    private static Optional<AbstractLiquibaseRule> findParentRule(List<AbstractLiquibaseRule> list, AbstractConfigurableRule object) {
        object = ((AbstractConfigurableRule)object).isConfigurable() ? (((DynamicRule)(object = (DynamicRule)object)).isCopy() ? ((DynamicRule)object).getParentRuleId() : ((AbstractConfigurableRule)object).getId()) : ((AbstractConfigurableRule)object).getId();
        return list.stream().filter(arg_0 -> ChecksShowCommandStep.lambda$findParentRule$3((UUID)object, arg_0)).findFirst();
    }

    private static List<List<String>> createTableWithData(List<AbstractLiquibaseRule> list, CheckSettingsConfig iterator, boolean bl2) {
        ArrayList<List<String>> arrayList;
        block6: {
            block5: {
                arrayList = new ArrayList<List<String>>();
                arrayList.add(new ArrayList<String>(columns.keySet()));
                if (iterator == null) break block5;
                for (AbstractConfigurableRule abstractConfigurableRule : ((CheckSettingsConfig)((Object)iterator)).getRules()) {
                    Optional<AbstractLiquibaseRule> optional = ChecksShowCommandStep.findParentRule(list, abstractConfigurableRule);
                    if (optional.isPresent()) {
                        optional = optional.get();
                        String string = "<None>";
                        String string2 = ((AbstractLiquibaseRule)((Object)optional)).getShortName();
                        if (abstractConfigurableRule.isConfigurable()) {
                            string = ((DynamicRule)abstractConfigurableRule).prettyPrintParameters();
                            string2 = ((DynamicRule)abstractConfigurableRule).getShortName();
                        }
                        arrayList.add(Arrays.asList(((AbstractLiquibaseRule)((Object)optional)).getName(), string2, ChecksShowCommandStep.scopesToString(optional.getScope()), StringUtil.join(((AbstractLiquibaseRule)((Object)optional)).getSupportedChangesetFormats(), (String)", "), Boolean.toString(abstractConfigurableRule.isEnabled()), Integer.toString(abstractConfigurableRule.getSeverity().getExitValue()), string, ((AbstractLiquibaseRule)((Object)optional)).getDescription()));
                        continue;
                    }
                    Scope.getCurrentScope().getLog(ChecksShowCommandStep.class).fine("Customized rule with ID " + abstractConfigurableRule.getId() + " does not match any rules loaded in the system, and will not be shown.");
                }
                break block6;
            }
            if (!bl2) break block6;
            for (AbstractLiquibaseRule abstractLiquibaseRule : list) {
                String string = "<None>";
                if (abstractLiquibaseRule.isConfigurable()) {
                    string = abstractLiquibaseRule.prettyPrintParameters();
                }
                arrayList.add(Arrays.asList(abstractLiquibaseRule.getName(), abstractLiquibaseRule.getShortName(), ChecksShowCommandStep.scopesToString(abstractLiquibaseRule.getScope()), StringUtil.join(abstractLiquibaseRule.getSupportedChangesetFormats(), (String)", "), String.valueOf(abstractLiquibaseRule.isEnabledByDefault()), Integer.toString(abstractLiquibaseRule.getSeverity().getExitValue()), string, abstractLiquibaseRule.getDescription()));
            }
        }
        return arrayList;
    }

    private static String scopesToString(List<ScopeEnum> list) {
        return StringUtil.join((Collection)list.stream().map(scopeEnum -> scopeEnum.toString().toLowerCase()).sorted().collect(Collectors.toList()), (String)", ");
    }

    private static Writer createOutputWriter(CommandResultsBuilder object) {
        String string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        object = object.getOutputStream();
        return new OutputStreamWriter((OutputStream)object, string);
    }

    private static /* synthetic */ boolean lambda$findParentRule$3(UUID uUID, AbstractLiquibaseRule abstractLiquibaseRule) {
        return abstractLiquibaseRule.getId().equals(uUID);
    }

    static {
        columns.put("Check Name", 30);
        columns.put("Short Name", 64);
        columns.put("Scope", Arrays.stream(ScopeEnum.values()).map(scopeEnum -> scopeEnum.toString().length()).max(Integer::compareTo).orElse(4) + 1);
        columns.put("Changeset Type", 15);
        columns.put("Enabled", 8);
        columns.put("Severity", 9);
        columns.put("Customization", 30);
        columns.put("Description", 30);
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_INTEGRATION_ARG = commandBuilder.argument("checksIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing checks show").build();
    }
}

