/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public abstract class AbstractLiquibaseDynamicRule
extends AbstractLiquibaseRule {
    private Map<String, String> generatedSqlCache = new HashMap<String, String>();

    @Override
    public final boolean evaluate(Facts object) {
        Database database;
        Object object2 = this.getChangeSetFromFacts((Facts)object);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = this.getSnapshotFromFacts((Facts)object);
        Database database2 = this.getDatabaseFromFacts((Facts)object);
        if (object2 == null && lazyDatabaseSnapshot == null) {
            return this.putResultSuccessful((ChangeSet)null, false, null);
        }
        if (!this.validateParameters((DynamicRule)(object = (DynamicRule)this.getAbstractConfigurableRuleFromFacts((Facts)object)))) {
            return this.putResultUnsuccessful((ChangeSet)null, "Validation failed on the parameters for this rule.", (DynamicRule)object);
        }
        boolean bl2 = false;
        if (object2 != null) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                database = (ChangeSet)object2.next();
                if (!this.shouldBeEvaluated((ChangeSet)database)) continue;
                boolean bl3 = this.internalEvaluate((ChangeSet)database, database2, (DynamicRule)object);
                if (bl2) continue;
                bl2 = bl3;
            }
        }
        if (lazyDatabaseSnapshot != null) {
            try {
                object2 = lazyDatabaseSnapshot.createDiffResult();
                database = lazyDatabaseSnapshot.getDatabase();
                for (DatabaseObject databaseObject : object2.getMissingObjects()) {
                    if (database.isLiquibaseObject(databaseObject) || !this.shouldBeEvaluated(databaseObject)) continue;
                    boolean bl4 = this.internalEvaluate(databaseObject, (DynamicRule)object);
                    if (bl2) continue;
                    bl2 = bl4;
                }
            }
            catch (CommandExecutionException | DatabaseException | InvalidExampleException throwable) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to generate diff from database snapshot, and thus failed to run the database checks.", throwable);
                this.putResultUnsuccessful((DatabaseObject)null, "Failed to generate diff from database snapshot", (DynamicRule)object);
            }
        }
        return bl2;
    }

    public String generateSqlFromChange(Change sqlStatementArray, Database database) {
        String string = this.generateKey((Change)sqlStatementArray);
        if (this.generatedSqlCache.containsKey(string)) {
            return this.generatedSqlCache.get(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (SqlStatement sqlStatement : sqlStatementArray.generateStatements(database)) {
            for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(sqlStatement, database)) {
                stringBuilder.append(sql.toSql());
                stringBuilder.append("\n");
            }
        }
        this.generatedSqlCache.put(string, stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String generateKey(Change change) {
        return change.generateCheckSum().toString();
    }

    private boolean validateParameters(DynamicRule object) {
        List<DynamicRuleParameter> list = ((DynamicRule)object).getParameters();
        if (list == null || list.isEmpty()) {
            object = String.format("Rule instance %s has no value parameters.  No check performed", ((DynamicRule)object).getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning((String)object);
            return false;
        }
        if ((long)list.size() < this.getParameters().stream().filter(ruleParameter -> ruleParameter.getShouldPrompt() == null).count()) {
            object = String.format("Rule instance %s has some missing value parameters.  No check performed.%nRun checks customize to supply values for the missing parameters.", ((DynamicRule)object).getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning((String)object);
            return false;
        }
        return true;
    }

    public abstract boolean internalEvaluate(ChangeSet var1, DynamicRule var2);

    public abstract boolean internalEvaluate(DatabaseObject var1, DynamicRule var2);

    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.internalEvaluate(changeSet, dynamicRule);
    }
}

