/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandScope;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.StringUtil;

public class EnvironmentValueProvider
extends AbstractMapConfigurationValueProvider {
    private Map<String, String> environment = System.getenv();
    private static AtomicBoolean printedInvalidEnvironmentVariablesMessage = new AtomicBoolean(false);

    public int getPrecedence() {
        return 150;
    }

    protected Map<?, ?> getMap() {
        return this.environment;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(CommandScope object) {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return;
        }
        object = new ArrayList();
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        for (Map.Entry<?, ?> entry : this.getMap().entrySet()) {
            String string = (String)entry.getKey();
            String string2 = ((String)entry.getKey()).toLowerCase();
            if (!string2.startsWith("liquibase_") || string2.equals("liquibase_home")) continue;
            String string3 = StringUtil.toCamelCase((String)string2);
            ConfigurationDefinition configurationDefinition = liquibaseConfiguration.getRegisteredDefinition(string3);
            if (configurationDefinition == null) {
                boolean bl2 = false;
                for (CommandDefinition commandDefinition : ((CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class)).getCommands(false)) {
                    SortedMap sortedMap = commandDefinition.getArguments();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string4 : commandDefinition.getName()) {
                        stringBuilder.append(StringUtil.upperCaseFirst((String)string4));
                    }
                    String string5 = StringUtil.lowerCaseFirst((String)string3.replace("liquibaseCommand", "").replaceFirst(stringBuilder.toString(), ""));
                    if ((CommandArgumentDefinition)sortedMap.get(string5) == null) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                object.add("- ".concat(String.valueOf(string)));
                continue;
            }
            if (configurationDefinition.getCurrentValue() != null && !configurationDefinition.getCurrentConfiguredValue().wasDefaultValueUsed()) continue;
            object.add("- ".concat(String.valueOf(string)));
        }
        Boolean bl3 = (Boolean)GlobalConfiguration.STRICT.getCurrentValue();
        if (!object.isEmpty()) {
            void var4_10;
            String string = System.lineSeparator() + System.lineSeparator() + "Liquibase detected the following invalid LIQUIBASE_* environment variables:" + System.lineSeparator() + System.lineSeparator() + StringUtil.join((Collection)object, (String)System.lineSeparator(), (boolean)true) + System.lineSeparator() + System.lineSeparator();
            if (bl3.booleanValue()) {
                String string6 = string + "Please rename them and run your command again, or set liquibase.strict=FALSE or LIQUIBASE_STRICT=FALSE." + System.lineSeparator();
            }
            String string7 = (String)var4_10 + "Find the list of valid environment variables at https://docs.liquibase.com/environment-variables" + System.lineSeparator();
            if (!printedInvalidEnvironmentVariablesMessage.getAndSet(true)) {
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(string7)));
                Scope.getCurrentScope().getLog(EnvironmentValueProvider.class).warning(string7);
            }
            if (bl3.booleanValue()) {
                throw new IllegalArgumentException(string7);
            }
        }
    }

    protected ProvidedValue lookupProvidedValue(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        boolean bl2 = false;
        ConfigurationDefinition configurationDefinition = ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getRegisteredDefinition(stringArray[0]);
        if (configurationDefinition != null) {
            bl2 = this.getUnlicensedVariables().contains(configurationDefinition);
        }
        if (!bl2 && !LicenseServiceUtils.isProLicenseValid()) {
            return null;
        }
        return super.lookupProvidedValue(stringArray);
    }

    protected String getSourceDescription() {
        return "Environment variable";
    }

    public Set<ConfigurationDefinition<?>> getUnlicensedVariables() {
        HashSet hashSet = new HashSet();
        hashSet.add(LiquibaseLabsConfiguration.LICENSE_KEY);
        hashSet.add(LiquibaseLabsConfiguration.LICENSE_PRO_LICENSE_KEY);
        return hashSet;
    }

    protected boolean keyMatches(String string, String string2) {
        if (super.keyMatches(string, string2 = StringUtil.trimToNull((String)string2))) {
            return true;
        }
        if ((string = StringUtil.toKabobCase((String)string.replace(".", "-"))).equalsIgnoreCase(string2)) {
            return true;
        }
        return string.replace("-", "_").equalsIgnoreCase(string2);
    }
}

