/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.change.Change;
import liquibase.change.EmptyChange;
import liquibase.change.RawSQLChange;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.exception.JDBCException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.log.LogFactory;
import liquibase.preconditions.ErrorPrecondition;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Preconditions;
import liquibase.util.MD5Util;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet {
    private List<Change> changes;
    private String id;
    private String author;
    private String filePath = "UNKNOWN CHANGE LOG";
    private String physicalFilePath;
    private Logger log;
    private String md5sum;
    private boolean alwaysRun;
    private boolean runOnChange;
    private Set<String> contexts;
    private Set<String> dbmsSet;
    private Boolean failOnError;
    private Set<String> validCheckSums = new HashSet<String>();
    private boolean runInTransaction;
    private List<Change> rollBackChanges = new ArrayList<Change>();
    private String comments;
    private Preconditions rootPrecondition;
    private List<SqlVisitor> sqlVisitors = new ArrayList<SqlVisitor>();

    public boolean shouldAlwaysRun() {
        return this.alwaysRun;
    }

    public boolean shouldRunOnChange() {
        return this.runOnChange;
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String physicalFilePath, String contextList, String dbmsList) {
        this(id, author, alwaysRun, runOnChange, filePath, physicalFilePath, contextList, dbmsList, false);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String physicalFilePath, String contextList, String dbmsList, boolean runInTransaction) {
        String[] strings;
        this.changes = new ArrayList<Change>();
        this.log = LogFactory.getLogger();
        this.id = id;
        this.author = author;
        this.filePath = filePath;
        this.physicalFilePath = physicalFilePath;
        this.alwaysRun = alwaysRun;
        this.runOnChange = runOnChange;
        this.runInTransaction = runInTransaction;
        if (StringUtils.trimToNull(contextList) != null) {
            strings = contextList.toLowerCase().split(",");
            this.contexts = new HashSet<String>();
            for (String string : strings) {
                this.contexts.add(string.trim().toLowerCase());
            }
        }
        if (StringUtils.trimToNull(dbmsList) != null) {
            strings = dbmsList.toLowerCase().split(",");
            this.dbmsSet = new HashSet<String>();
            for (String string : strings) {
                this.dbmsSet.add(string.trim().toLowerCase());
            }
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPhysicalFilePath() {
        if (this.physicalFilePath == null) {
            return this.filePath;
        }
        return this.physicalFilePath;
    }

    public String getMd5sum() {
        if (this.md5sum == null) {
            StringBuffer stringToMD5 = new StringBuffer();
            for (Change change : this.getChanges()) {
                stringToMD5.append(change.getMD5Sum()).append(":");
            }
            this.md5sum = MD5Util.computeMD5(stringToMD5.toString());
        }
        return this.md5sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Database database) throws MigrationFailedException {
        boolean markRan;
        block43: {
            boolean skipChange = false;
            markRan = true;
            try {
                if (this.runInTransaction) {
                    database.setAutoCommit(false);
                }
                database.getJdbcTemplate().comment("Changeset " + this.toString());
                if (StringUtils.trimToNull(this.getComments()) != null) {
                    String comments = this.getComments();
                    String[] lines = comments.split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        if (i <= 0) continue;
                        lines[i] = database.getLineComment() + " " + lines[i];
                    }
                    database.getJdbcTemplate().comment(StringUtils.join(Arrays.asList(lines), "\n"));
                }
                if (database.getJdbcTemplate().executesStatements() && this.rootPrecondition != null) {
                    StringBuffer message;
                    try {
                        this.rootPrecondition.check(database, null);
                    }
                    catch (PreconditionFailedException e) {
                        message = new StringBuffer();
                        message.append(StreamUtil.getLineSeparator());
                        for (FailedPrecondition failedPrecondition : e.getFailedPreconditions()) {
                            message.append("          ").append(failedPrecondition.toString());
                            message.append(StreamUtil.getLineSeparator());
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.HALT)) {
                            e.printStackTrace();
                            throw new MigrationFailedException(this, message.toString());
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.CONTINUE)) {
                            skipChange = true;
                            markRan = false;
                            this.log.log(Level.INFO, "Continuing past ChangeSet: " + this.toString() + " due to precondition failure: " + message);
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.MARK_RAN)) {
                            skipChange = true;
                            this.log.log(Level.INFO, "Marking ChangeSet: " + this.toString() + " ran due to precondition failure: " + message);
                        }
                        if (this.rootPrecondition.getOnFail().equals((Object)Preconditions.FailOption.WARN)) {
                            this.log.log(Level.WARNING, "Running change set despite failed precondition.  ChangeSet: " + this.toString() + ": " + message);
                        }
                        throw new MigrationFailedException(this, "Unexpected precondition onFail attribute: " + (Object)((Object)this.rootPrecondition.getOnFail()));
                    }
                    catch (PreconditionErrorException e) {
                        message = new StringBuffer();
                        message.append(StreamUtil.getLineSeparator());
                        for (ErrorPrecondition errorPrecondition : e.getErrorPreconditions()) {
                            message.append("          ").append(errorPrecondition.toString());
                            message.append(StreamUtil.getLineSeparator());
                        }
                        if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.HALT)) {
                            throw new MigrationFailedException(this, message.toString());
                        }
                        if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.CONTINUE)) {
                            skipChange = true;
                            markRan = false;
                            this.log.log(Level.INFO, "Continuing past ChangeSet: " + this.toString() + " due to precondition error: " + message);
                        } else if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.MARK_RAN)) {
                            skipChange = true;
                            markRan = true;
                            this.log.log(Level.INFO, "Marking ChangeSet: " + this.toString() + " due ran to precondition error: " + message);
                        } else if (this.rootPrecondition.getOnError().equals((Object)Preconditions.ErrorOption.WARN)) {
                            this.log.log(Level.WARNING, "Running change set despite errored precondition.  ChangeSet: " + this.toString() + ": " + message);
                        } else {
                            throw new MigrationFailedException(this, "Unexpected precondition onError attribute: " + (Object)((Object)this.rootPrecondition.getOnError()));
                        }
                        database.rollback();
                    }
                }
                if (!skipChange) {
                    for (Change change : this.changes) {
                        try {
                            change.setUp();
                        }
                        catch (SetupException se) {
                            throw new MigrationFailedException(this, (Throwable)se);
                        }
                    }
                    this.log.finest("Reading ChangeSet: " + this.toString());
                    for (Change change : this.getChanges()) {
                        change.executeStatements(database, this.sqlVisitors);
                        this.log.finest(change.getConfirmationMessage());
                    }
                    if (!this.runInTransaction) {
                        database.commit();
                    }
                    this.log.finest("ChangeSet " + this.toString() + " has been successfully run.");
                    database.commit();
                } else {
                    this.log.finest("Skipping ChangeSet: " + this.toString());
                }
            }
            catch (Exception e) {
                try {
                    database.rollback();
                }
                catch (Exception e1) {
                    throw new MigrationFailedException(this, (Throwable)e);
                }
                if (this.getFailOnError() != null && !this.getFailOnError().booleanValue()) {
                    this.log.log(Level.INFO, "Change set " + this.toString(false) + " failed, but failOnError was false", e);
                    break block43;
                }
                if (e instanceof MigrationFailedException) {
                    throw (MigrationFailedException)e;
                }
                throw new MigrationFailedException(this, (Throwable)e);
            }
            finally {
                if (this.runInTransaction) {
                    try {
                        database.setAutoCommit(true);
                    }
                    catch (JDBCException e) {
                        throw new MigrationFailedException(this, "Could not reset autocommit");
                    }
                }
            }
        }
        return markRan;
    }

    public void rolback(Database database) throws RollbackFailedException {
        try {
            database.getJdbcTemplate().comment("Rolling Back ChangeSet: " + this.toString());
            if (this.rollBackChanges != null && this.rollBackChanges.size() > 0) {
                for (Change rollback : this.rollBackChanges) {
                    for (SqlStatement statement : rollback.generateStatements(database)) {
                        try {
                            database.getJdbcTemplate().execute(statement, this.sqlVisitors);
                        }
                        catch (JDBCException e) {
                            throw new RollbackFailedException("Error executing custom SQL [" + statement + "]", e);
                        }
                    }
                }
            } else {
                List<Change> changes = this.getChanges();
                for (int i = changes.size() - 1; i >= 0; --i) {
                    Change change = changes.get(i);
                    change.executeRollbackStatements(database, this.sqlVisitors);
                    this.log.finest(change.getConfirmationMessage());
                }
            }
            database.commit();
            this.log.finest("ChangeSet " + this.toString() + " has been successfully rolled back.");
        }
        catch (Exception e) {
            try {
                database.rollback();
            }
            catch (JDBCException jDBCException) {
                // empty catch block
            }
            throw new RollbackFailedException(e);
        }
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public void addChange(Change change) {
        this.changes.add(change);
        change.setChangeSet(this);
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public Set<String> getDbmsSet() {
        return this.dbmsSet;
    }

    public String toString(boolean includeMD5Sum) {
        return this.filePath + "::" + this.getId() + "::" + this.getAuthor() + (includeMD5Sum ? "::(MD5Sum: " + this.getMd5sum() + ")" : "");
    }

    public String toString() {
        return this.toString(true);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Element createNode(Document currentChangeLogDOM) {
        Element node = currentChangeLogDOM.createElement("changeSet");
        node.setAttribute("id", this.getId());
        node.setAttribute("author", this.getAuthor());
        if (this.alwaysRun) {
            node.setAttribute("alwaysRun", "true");
        }
        if (this.runOnChange) {
            node.setAttribute("runOnChange", "true");
        }
        if (this.failOnError != null) {
            node.setAttribute("failOnError", this.failOnError.toString());
        }
        if (this.getContexts() != null && this.getContexts().size() > 0) {
            StringBuffer contextString = new StringBuffer();
            for (String context : this.getContexts()) {
                contextString.append(context).append(",");
            }
            node.setAttribute("context", contextString.toString().replaceFirst(",$", ""));
        }
        if (this.getDbmsSet() != null && this.getDbmsSet().size() > 0) {
            StringBuffer dbmsString = new StringBuffer();
            for (String dbms : this.getDbmsSet()) {
                dbmsString.append(dbms).append(",");
            }
            node.setAttribute("dbms", dbmsString.toString().replaceFirst(",$", ""));
        }
        if (StringUtils.trimToNull(this.getComments()) != null) {
            Element commentsElement = currentChangeLogDOM.createElement("comment");
            Text commentsText = currentChangeLogDOM.createTextNode(this.getComments());
            commentsElement.appendChild(commentsText);
            node.appendChild(commentsElement);
        }
        for (Change change : this.getChanges()) {
            node.appendChild(change.createNode(currentChangeLogDOM));
        }
        return node;
    }

    public Change[] getRollBackChanges() {
        return this.rollBackChanges.toArray(new Change[this.rollBackChanges.size()]);
    }

    public void addRollBackSQL(String sql) {
        if (StringUtils.trimToNull(sql) == null) {
            this.rollBackChanges.add(new EmptyChange());
            return;
        }
        for (String statment : StringUtils.splitSQL(sql)) {
            this.rollBackChanges.add(new RawSQLChange(statment.trim()));
        }
    }

    public void addRollbackChange(Change change) throws UnsupportedChangeException {
        this.rollBackChanges.add(change);
    }

    public boolean canRollBack() {
        if (this.rollBackChanges != null && this.rollBackChanges.size() > 0) {
            return true;
        }
        for (Change change : this.getChanges()) {
            if (change.canRollBack()) continue;
            return false;
        }
        return true;
    }

    public String getDescription() {
        List<Change> changes = this.getChanges();
        if (changes.size() == 0) {
            return "Empty";
        }
        StringBuffer returnString = new StringBuffer();
        Class<?> lastChangeClass = null;
        int changeCount = 0;
        for (Change change : changes) {
            if (change.getClass().equals(lastChangeClass)) {
                ++changeCount;
            } else if (changeCount > 1) {
                returnString.append(" (x").append(changeCount).append(")");
                returnString.append(", ");
                returnString.append(change.getChangeName());
                changeCount = 1;
            } else {
                returnString.append(", ").append(change.getChangeName());
                changeCount = 1;
            }
            lastChangeClass = change.getClass();
        }
        if (changeCount > 1) {
            returnString.append(" (x").append(changeCount).append(")");
        }
        return returnString.toString().replaceFirst("^, ", "");
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addValidCheckSum(String text) {
        this.validCheckSums.add(text);
    }

    public boolean isCheckSumValid(String storedCheckSum) {
        String currentMd5Sum = this.getMd5sum();
        if (currentMd5Sum == null) {
            return true;
        }
        if (storedCheckSum == null) {
            return true;
        }
        if (currentMd5Sum.equals(storedCheckSum)) {
            return true;
        }
        for (String validCheckSum : this.validCheckSums) {
            if (!currentMd5Sum.equals(validCheckSum)) continue;
            return true;
        }
        return false;
    }

    public Preconditions getPrecondition() {
        return this.rootPrecondition;
    }

    public void setPreconditions(Preconditions preconditions) {
        this.rootPrecondition = preconditions;
    }

    public void addSqlVisitor(SqlVisitor sqlVisitor) {
        this.sqlVisitors.add(sqlVisitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RunStatus {
        NOT_RAN,
        ALREADY_RAN,
        RUN_AGAIN,
        INVALID_MD5SUM;

    }
}

