/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ant;

import java.io.Writer;
import liquibase.Liquibase;
import liquibase.UIFactory;
import liquibase.ant.BaseLiquibaseTask;
import org.apache.tools.ant.BuildException;

public class DatabaseUpdateTask
extends BaseLiquibaseTask {
    private boolean dropFirst = false;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public void execute() throws BuildException {
        if (!this.shouldRun()) {
            return;
        }
        Liquibase liquibase = null;
        try {
            Writer writer;
            liquibase = this.createLiquibase();
            if (this.isPromptOnNonLocalDatabase() && !liquibase.isSafeToRunMigration() && UIFactory.getInstance().getFacade().promptForNonLocalDatabase(liquibase.getDatabase())) {
                throw new BuildException("Chose not to run against non-production database");
            }
            if (this.isDropFirst()) {
                liquibase.dropAll();
            }
            if ((writer = this.createOutputWriter()) == null) {
                liquibase.update(this.getContexts());
            } else {
                liquibase.update(this.getContexts(), writer);
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

