/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.text.ParseException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.structure.CacheDatabaseSnapshot;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "cache";

    @Override
    public String getBlobType() {
        return "LONGVARBINARY";
    }

    @Override
    public String getBooleanType() {
        return "INTEGER";
    }

    @Override
    public String getClobType() {
        return "LONGVARCHAR";
    }

    @Override
    public String getCurrencyType() {
        return "MONEY";
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "SYSDATE";
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:Cache")) {
            return "com.intersys.jdbc.CacheDriver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return "Cache";
    }

    @Override
    public String getTypeName() {
        return PRODUCT_NAME;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return "";
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            String stringDefaultValue = (String)defaultValue;
            if (stringDefaultValue.charAt(0) == '\"' && stringDefaultValue.charAt(stringDefaultValue.length() - 1) == '\"') {
                defaultValue = stringDefaultValue.substring(1, stringDefaultValue.length() - 1);
            } else if (stringDefaultValue.startsWith("$")) {
                defaultValue = "OBJECTSCRIPT '" + defaultValue + "'";
            }
        }
        return super.convertDatabaseValueToJavaObject(defaultValue, dataType, columnSize, decimalDigits);
    }

    @Override
    public String getViewDefinition(String schemaName, String viewName) throws JDBCException {
        return null;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new CacheDatabaseSnapshot(this, statusListeners, schema);
    }
}

