/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DB2DatabaseSnapshot;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2Database
extends AbstractDatabase {
    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return this.getDatabaseProductName(conn).startsWith("DB2");
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:db2")) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return "DB2";
    }

    @Override
    public String getTypeName() {
        return "db2";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "CURRENT TIMESTAMP";
    }

    @Override
    public String getBooleanType() {
        return "SMALLINT";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        if (this.isDateOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("DATE(");
            val.append(normalLiteral);
            val.append(')');
            return val.toString();
        }
        if (this.isTimeOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("TIME(");
            val.append(normalLiteral);
            val.append(')');
            return val.toString();
        }
        if (this.isDateTime(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("TIMESTAMP(");
            val.append(normalLiteral);
            val.append(')');
            return val.toString();
        }
        return "UNSUPPORTED:" + isoDate;
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL(19,4)";
    }

    @Override
    public String getUUIDType() {
        return "VARCHAR(36)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return new RawSqlStatement("SELECT SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES WHERE SEQTYPE='S' AND SEQSCHEMA = '" + this.convertRequestedSchemaToSchema(schema) + "'");
    }

    @Override
    public boolean shouldQuoteValue(String value) {
        return super.shouldQuoteValue(value) && !value.startsWith("\"SYSIBM\"");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String name) throws JDBCException {
        return new RawSqlStatement("select view_definition from SYSIBM.VIEWS where TABLE_NAME='" + name + "' and TABLE_SCHEMA='" + this.convertRequestedSchemaToSchema(schemaName) + "'");
    }

    @Override
    public String getViewDefinition(String schemaName, String name) throws JDBCException {
        return super.getViewDefinition(schemaName, name).replaceFirst("CREATE VIEW \\w+ AS ", "");
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (dataType == 93) {
                defaultValue = ((String)defaultValue).replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
            } else if (dataType == 92) {
                defaultValue = ((String)defaultValue).replaceFirst("^\"SYSIBM\".\"TIME\"\\('", "").replaceFirst("'\\)", "");
            } else if (dataType == 91) {
                defaultValue = ((String)defaultValue).replaceFirst("^\"SYSIBM\".\"DATE\"\\('", "").replaceFirst("'\\)", "");
            }
        }
        return super.convertDatabaseValueToJavaObject(defaultValue, dataType, columnSize, decimalDigits);
    }

    @Override
    protected Date parseDate(String dateAsString) throws DateParseException {
        try {
            if (dateAsString.indexOf(32) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf(46) > 0 && dateAsString.indexOf(45) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSSSSS").parse(dateAsString);
            }
            if (dateAsString.indexOf(58) > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf(46) > 0) {
                return new SimpleDateFormat("HH.mm.ss").parse(dateAsString);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateAsString);
        }
        catch (ParseException e) {
            throw new DateParseException(dateAsString);
        }
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws JDBCException {
        if (requestedSchema == null) {
            return this.getDefaultDatabaseSchemaName();
        }
        return requestedSchema.toUpperCase();
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws JDBCException {
        return null;
    }

    @Override
    public String generatePrimaryKeyName(String tableName) {
        String pkName = super.generatePrimaryKeyName(tableName);
        if (pkName.length() > 18) {
            pkName = pkName.substring(0, 17);
        }
        return pkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isColumnAutoIncrement(String schemaName, String tableName, String columnName) throws SQLException, JDBCException {
        boolean autoIncrement = false;
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement("SELECT IDENTITY FROM SYSCAT.COLUMNS WHERE TABSCHEMA = ? AND TABNAME = ? AND COLNAME = ? AND HIDDEN != 'S'");
            stmt.setString(1, this.convertRequestedSchemaToSchema(schemaName));
            stmt.setString(2, tableName);
            stmt.setString(3, columnName);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String identity = rs.getString("IDENTITY");
                if (!identity.equalsIgnoreCase("Y")) continue;
                autoIncrement = true;
            }
            rs.close();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return autoIncrement;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new DB2DatabaseSnapshot(this, statusListeners, schema);
    }
}

