/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.HsqlConnectionDelegate;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.HsqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;
import liquibase.util.ISODateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDatabase
extends AbstractDatabase {
    private static String START_CONCAT = "CONCAT(";
    private static String END_CONCAT = ")";
    private static String SEP_CONCAT = ", ";

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return "HSQL Database Engine".equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbcDriver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return "Hsqldb";
    }

    @Override
    public String getTypeName() {
        return "hsqldb";
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return "PUBLIC";
    }

    @Override
    public String getBooleanType() {
        return "BOOLEAN";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "VARCHAR(36)";
    }

    @Override
    public String getClobType() {
        return "LONGVARCHAR";
    }

    @Override
    public String getBlobType() {
        return "LONGVARBINARY";
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "NOW()";
    }

    @Override
    public String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY IDENTITY";
    }

    @Override
    public String getConcatSql(String ... values) {
        if (values == null) {
            return null;
        }
        return this.getConcatSql(Arrays.asList(values));
    }

    private String getConcatSql(List<String> values) {
        if (values.size() == 1) {
            return values.get(0);
        }
        return START_CONCAT + values.get(0) + SEP_CONCAT + this.getConcatSql(values.subList(1, values.size())) + END_CONCAT;
    }

    @Override
    public String getDateLiteral(String isoDate) {
        String returnString = isoDate;
        try {
            if (this.isDateTime(isoDate)) {
                ISODateFormat isoTimestampFormat = new ISODateFormat();
                SimpleDateFormat dbTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                returnString = dbTimestampFormat.format(isoTimestampFormat.parse(isoDate));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Unexpected date format: " + isoDate, e);
        }
        return "'" + returnString + "'";
    }

    @Override
    protected Date parseDate(String dateAsString) throws DateParseException {
        try {
            if (dateAsString.indexOf(" ") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").parse(dateAsString);
            }
            if (dateAsString.indexOf(":") > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(dateAsString);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateAsString);
        }
        catch (ParseException e) {
            throw new DateParseException(dateAsString);
        }
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return new RawSqlStatement("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES WHERE SEQUENCE_SCHEMA = '" + this.convertRequestedSchemaToSchema(schema) + "'");
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public void setConnection(Connection conn) {
        super.setConnection(new HsqlConnectionDelegate(conn));
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String name) throws JDBCException {
        return new RawSqlStatement("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.SYSTEM_VIEWS WHERE TABLE_NAME = '" + name + "' AND TABLE_SCHEMA='" + this.convertRequestedSchemaToSchema(schemaName) + "'");
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws JDBCException {
        return super.convertRequestedSchemaToSchema(requestedSchema).toUpperCase();
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new HsqlDatabaseSnapshot(this, statusListeners, schema);
    }
}

