/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.MySqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "MySQL";

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getTypeName() {
        return "mysql";
    }

    @Override
    public String getConnectionUsername() throws JDBCException {
        return super.getConnectionUsername().replaceAll("\\@.*", "");
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:mysql")) {
            return "com.mysql.jdbc.Driver";
        }
        return null;
    }

    @Override
    public String getBooleanType() {
        return "TINYINT(1)";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "TEXT";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "DATETIME";
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "NOW()";
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        returnString.append("CONCAT_WS(");
        for (String value : values) {
            returnString.append(value).append(", ");
        }
        return returnString.toString().replaceFirst(", $", ")");
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws JDBCException {
        if (requestedSchema == null) {
            return this.getDefaultDatabaseSchemaName();
        }
        return requestedSchema;
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws JDBCException {
        return requestedSchema;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String viewName) throws JDBCException {
        return new RawSqlStatement("select view_definition from information_schema.views where table_name='" + viewName + "' AND table_schema='" + schemaName + "'");
    }

    @Override
    public String escapeTableName(String schemaName, String tableName) {
        if (schemaName != null) {
            return "`" + schemaName + "`.`" + tableName + "`";
        }
        return "`" + tableName + "`";
    }

    @Override
    public String escapeConstraintName(String constraintName) {
        if (constraintName == null) {
            return null;
        }
        return "`" + constraintName + "`";
    }

    @Override
    public String escapeColumnName(String schemaName, String tableName, String columnName) {
        return "`" + columnName + "`";
    }

    @Override
    public String escapeColumnNameList(String columnNames) {
        StringBuffer sb = new StringBuffer();
        for (String columnName : columnNames.split(",")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("`").append(columnName.trim()).append("`");
        }
        return sb.toString();
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new MySqlDatabaseSnapshot(this, statusListeners, schema);
    }
}

